'use strict';

/**
 * @name session-timer.directive.js
 * @desc session-timer directive that serves to control the session timer
 */

export default angular.module('app.session-timer.directive', [])
    .directive('sessionTimer', sessionTimer);

sessionTimer.$inject = ['$timeout', '$interval', '$state', 'semossCoreService', 'monolithService', 'CONFIG'];

function sessionTimer($timeout, $interval, $state, semossCoreService, monolithService, CONFIG) {
    sessionTimerLink.$inject = ['scope', 'ele'];

    return {
        restrict: 'E',
        template: require('./session-timer.directive.html'),
        link: sessionTimerLink,
        scope: {}
    };

    function sessionTimerLink(scope) {
        var sessionResetListener,
            configInitListener;

        scope.sessionTimer = {};
        // scope.sessionTimer.sessionLength = 1790000; // 30 minutes minus 10 seconds
        scope.sessionTimer.session = {};

        scope.sessionTimer.endSession = endSession;
        scope.sessionTimer.continueSession = continueSession;

        /**
         * @name endSession
         * @desc ends the session
         * @returns {void}
         */
        function endSession() {
            scope.sessionTimer.session.open = false;

            // redirect to the login page
            // TODO need to make a call to actually end the session so FE/BE can be synced in terms of the session
            monolithService.logout('all');
            // window.location.reload();

            if (scope.sessionTimer.session.timeout) {
                $timeout.cancel(scope.sessionTimer.session.timeout);
            }

            if (scope.sessionTimer.session.interval) {
                $interval.cancel(scope.sessionTimer.session.interval);
            }
        }

        /**
         * @name continueSession
         * @desc continue the session by making a BE call
         * @returns {void}
         */
        function continueSession() {
            scope.sessionTimer.session.open = false;

            setSession();
            // make a backend call to reset timer
            monolithService.runPixel('', 'true;');
        }

        // initialize the timer
        /**
         * @name setSession
         * @desc set the session timer
         * @returns {void}
         */
        function setSession() {
            if (scope.sessionTimer.session.timeout) {
                $timeout.cancel(scope.sessionTimer.session.timeout);
            }

            if (scope.sessionTimer.session.interval) {
                $interval.cancel(scope.sessionTimer.session.interval);
            }

            scope.sessionTimer.session.timeout = $timeout(function () {
                scope.sessionTimer.session.open = true;
                scope.sessionTimer.session.timer = 120;

                scope.sessionTimer.session.interval = $interval(function () {
                    scope.sessionTimer.session.timer -= 1;

                    // timer is up so lets end the session
                    if (scope.sessionTimer.session.timer === 0) {
                        if (scope.sessionTimer.session.timeout) {
                            $timeout.cancel(scope.sessionTimer.session.timeout);
                        }

                        if (scope.sessionTimer.session.interval) {
                            $interval.cancel(scope.sessionTimer.session.interval);
                        }

                        // scope.sessionTimer.session.active = false;
                        scope.sessionTimer.session.redirectInterval = $interval(function () {
                            scope.sessionTimer.session.redirectTimer -= 1;
                            if (scope.sessionTimer.session.redirectTimer === 0) {
                                $interval.cancel(scope.sessionTimer.session.redirectInterval);
                                semossCoreService.emit('close-all-apps');
                                monolithService.invalidateSession();
                                initializeVariables();
                                configureTimeout();
                                // window.location.reload();
                            }
                        }, 1000);
                    }
                }, 1000);
            }, scope.sessionTimer.session.reset);
        }

        /**
         * @name configureTimeout
         * @desc sets timeout then session
         * @return {void}
         */
        function configureTimeout() {
            if (CONFIG.timeout) {
                scope.sessionTimer.session.reset = (CONFIG.timeout * 60 * 1000) - 120000;
                setSession();
            }
        }

        /**
         * @name initializeVariables
         * @desc set the initial state of the variables
         * @returns {void}
         */
        function initializeVariables() {
            scope.sessionTimer.session = {
                open: false,
                reset: 1680000, // 30 minutes minus 10 seconds
                timer: 120,
                redirectTimer: 10,
                timeout: undefined,
                interval: undefined,
                redirectInterval: undefined,
                active: true
            };
        }

        /**
         * @name initialize
         * @desc function that is called on directive load
         * @returns {void}
         */
        function initialize() {
            initializeVariables();
            sessionResetListener = semossCoreService.on('session-reset', function () {
                setSession();
            });
            configInitListener = semossCoreService.on('initialize-config', function () {
                configureTimeout();
            });
        }

        initialize();

        scope.$on('$destroy', function () {
            sessionResetListener();
            configInitListener();
        });
    }
}
