'use strict';

/**
 * @name SyncAppToGithub
 * @desc template for what user needs to run this job
 */
export default angular.module('app.sync-app-to-github.directive', [])
    .directive('syncAppToGithub', syncAppToGithub);

syncAppToGithub.$inject = ['ENDPOINT', 'semossCoreService'];

function syncAppToGithub(ENDPOINT, semossCoreService) {
    syncAppToGithubLink.$inject = ['scope'];

    return {
        restrict: 'E',
        scope: {
            job: '='
        },
        link: syncAppToGithubLink,
        template: require('./sync-app-to-github.directive.html')
    };

    function syncAppToGithubLink(scope) {
        scope.allApps = [];
        function initialize() {
            // add in props on jobTypeTemplate
            if (!scope.job.jobTypeTemplate.hasOwnProperty('dual')) {
                scope.job.jobTypeTemplate.dual = true;
            }
            if (!scope.job.jobTypeTemplate.hasOwnProperty('syncDatabase')) {
                scope.job.jobTypeTemplate.syncDatabase = true;
            }
            if (!scope.job.jobTypeTemplate.hasOwnProperty('app')) {
                scope.job.jobTypeTemplate.app = '';
            }
            if (!scope.job.jobTypeTemplate.hasOwnProperty('repository')) {
                scope.job.jobTypeTemplate.repository = '';
            }
            if (!scope.job.jobTypeTemplate.hasOwnProperty('password')) {
                scope.job.jobTypeTemplate.password = '';
            }
            var message = semossCoreService.utility.random('query-pixel');

            semossCoreService.once(message, function (response) {
                var output = response.pixelReturn[0].output,
                    i,
                    len;

                scope.allApps = [];

                for (i = 0, len = output.length; i < len; i++) {
                    scope.allApps.push({
                        'display': String(output[i].app_name).replace(/_/g, ' '),
                        'value': output[i].app_id,
                        'image': semossCoreService.app.generateAppImageURL(output[i].app_id)
                    });
                }

                // set a default on the dropdown as current app
                scope.job.jobTypeTemplate.app = semossCoreService.app.get('selectedApp');
            });

            semossCoreService.emit('query-pixel', {
                commandList: [{
                    meta: true,
                    type: 'getDatabaseList',
                    components: [],
                    terminal: true
                }],
                response: message
            });
        }

        // update job as user changes values
        scope.$watchCollection('job.jobTypeTemplate', function () {
            var query = 'SyncApp(',
                template = scope.job.jobTypeTemplate;

            query += "app=['" + template.app + "'], ";
            query += "repository=['" + template.repository + "'], ";
            query += "username=['" + template.username + "'], ";
            query += "password=['" + template.password + "'], ";
            query += "dual=['" + template.dual + "'], ";
            query += "syncDatabase=['" + template.syncDatabase + "']);";

            scope.job.jobTypeTemplate.templatePixelQuery = query;
        });

        initialize();
    }
}
