'use strict';

export default angular.module('app.metamodel.metamodel-table', [])
    .directive('metamodelTable', metamodelTableDirective);

import './metamodel-table.scss';

metamodelTableDirective.$inject = ['$timeout', 'semossCoreService'];

function metamodelTableDirective($timeout, semossCoreService) {
    metamodelTableCtrl.$inject = [];
    metamodelTableLink.$inject = ['scope', 'ele', 'attrs', 'ctrl'];

    return {
        restrict: 'E',
        template: require('./metamodel-table.directive.html'),
        scope: {},
        require: [],
        controllerAs: 'metamodelTable',
        bindToController: {
            metamodel: '=',
            allTables: '=',
            selectedTable: '=',
            change: '&?'
        },
        controller: metamodelTableCtrl,
        link: metamodelTableLink
    };


    function metamodelTableCtrl() {}

    function metamodelTableLink(scope, ele, attrs, ctrl) {
        scope.metamodelTable.tableInformation = {
            options: [],
            selected: ''
        };

        scope.metamodelTable.columnInformation = {
            options: [],
            selected: []
        };

        scope.metamodelTable.setColumn = setColumn;
        scope.metamodelTable.cancelTable = cancelTable;
        scope.metamodelTable.saveTable = saveTable;

        /** Metamodel Functions */

        /** Table Functions */
        /**
         * @name setTable
         * @desc selects a column to grab data about
         * @return {void}
         */
        function setTable() {
            var table,
                keepSelected = false;

            // this is the selected information
            scope.metamodelTable.tableInformation.options = [];
            for (table in scope.metamodelTable.metamodel.tables) {
                if (scope.metamodelTable.metamodel.tables.hasOwnProperty(table)) {
                    scope.metamodelTable.tableInformation.options.push({
                        table: scope.metamodelTable.metamodel.tables[table].table,
                        alias: scope.metamodelTable.metamodel.tables[table].alias
                    });

                    if (scope.metamodelTable.selectedTable === scope.metamodelTable.metamodel.tables[table].table) {
                        keepSelected = true;
                    }
                }
            }

            // sort
            scope.metamodelTable.tableInformation.options.sort(function (a, b) {
                var textA = a.alias.toUpperCase(),
                    textB = b.alias.toUpperCase();

                if (textA < textB) {
                    return -1;
                }
                if (textA > textB) {
                    return 1;
                }

                return 0;
            });


            if (!keepSelected) {
                scope.metamodelTable.tableInformation.selected = scope.metamodelTable.tableInformation.options[0].table;
            } else {
                scope.metamodelTable.tableInformation.selected = scope.metamodelTable.selectedTable;
            }

            if (scope.metamodelTable.tableInformation.selected) {
                setColumn();
            }
        }

        /**
         * @name setColumn
         * @desc grabs the column information
         * @return {void}
         */
        function setColumn() {
            var tableMapping = {},
                table,
                column;

            // create the options (aka things that haven't been added)
            scope.metamodelTable.columnInformation.options = [];

            // create a mapping
            for (table in scope.metamodelTable.allTables) {
                if (scope.metamodelTable.allTables.hasOwnProperty(table)) {
                    tableMapping[table] = scope.metamodelTable.allTables[table].alias;
                }
            }

            // delete from the mapping if it is already there
            for (table in scope.metamodelTable.metamodel.tables) {
                if (scope.metamodelTable.metamodel.tables.hasOwnProperty(table)) {
                    if (scope.metamodelTable.metamodel.tables[table].table !== scope.metamodelTable.tableInformation.selected) {
                        // delete the options
                        for (column in scope.metamodelTable.metamodel.tables[table].columns) {
                            if (scope.metamodelTable.metamodel.tables[table].columns.hasOwnProperty(column)) {
                                if (tableMapping.hasOwnProperty(column)) {
                                    delete tableMapping[column];
                                }
                            }
                        }

                        // delete the table
                        if (tableMapping.hasOwnProperty(table)) {
                            delete tableMapping[table];
                        }
                    }
                }
            }

            if (tableMapping.hasOwnProperty(scope.metamodelTable.tableInformation.selected)) {
                delete tableMapping[scope.metamodelTable.tableInformation.selected];
            }

            for (table in tableMapping) {
                if (tableMapping.hasOwnProperty(table)) {
                    scope.metamodelTable.columnInformation.options.push({
                        column: table,
                        alias: tableMapping[table]
                    });
                }
            }

            // sort
            scope.metamodelTable.columnInformation.options.sort(function (a, b) {
                var textA = a.alias.toUpperCase(),
                    textB = b.alias.toUpperCase();

                if (textA < textB) {
                    return -1;
                }
                if (textA > textB) {
                    return 1;
                }

                return 0;
            });

            // create the selected
            scope.metamodelTable.columnInformation.selected = [];
            if (scope.metamodelTable.metamodel.tables.hasOwnProperty(scope.metamodelTable.tableInformation.selected)) {
                for (column in scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns) {
                    if (scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns.hasOwnProperty(column)) {
                        scope.metamodelTable.columnInformation.selected.push(scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns[column].column);
                    }
                }
            }
        }

        /**
         * @name cancelTable
         * @desc edit a column alias
         * @param {string} selected - selected table information
         * @return {void}
         */
        function cancelTable() {
            scope.metamodelTable.tableInformation = {
                options: [],
                selected: ''
            };

            scope.metamodelTable.columnInformation = {
                options: [],
                selected: []
            };

            // push the changes via a callback
            if (scope.metamodelTable.change) {
                scope.metamodelTable.change({
                    model: scope.metamodelTable.metamodel
                });
            }
        }

        /**
         * @name saveTable
         * @desc edit a column alias
         * @return {void}
         */
        function saveTable() {
            var columnMapping = {},
                i,
                len;

            // create a mapping, this will help us update the tables (rather than replace)
            columnMapping = {};
            for (i = 0, len = scope.metamodelTable.columnInformation.selected.length; i < len; i++) {
                columnMapping[scope.metamodelTable.columnInformation.selected[i]] = i;
            }

            // remove columns that are missing
            for (i in scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns) {
                // remove the relationship, that if a table in the mapping
                if (!columnMapping.hasOwnProperty(scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns[i].column)) {
                    delete scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns[i];
                }
            }

            // delete the column
            for (i in scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns) {
                if (!columnMapping.hasOwnProperty(scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns[i].column)) { // remove the columns, that aren't in the mapping
                    delete scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns[i];
                } else { // delete the mapping value, because it is already added
                    delete columnMapping[scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns[i].column];
                }
            }

            // add the column that are remaining in the mapping
            for (i in columnMapping) {
                if (columnMapping.hasOwnProperty(i)) {
                    scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns[i] = {
                        alias: scope.metamodelTable.allTables[i].columns[i].alias,
                        column: scope.metamodelTable.allTables[i].columns[i].column,
                        table: scope.metamodelTable.tableInformation.selected,
                        isPrimKey: false,
                        type: scope.metamodelTable.allTables[i].columns[i].type,
                        typeFormat: scope.metamodelTable.allTables[i].columns[i].typeFormat,
                        description: scope.metamodelTable.allTables[i].columns[i].description,
                        logical: scope.metamodelTable.allTables[i].columns[i].logical
                    };
                }
            }

            // add the table column
            scope.metamodelTable.metamodel.tables[scope.metamodelTable.tableInformation.selected].columns[scope.metamodelTable.tableInformation.selected] = {
                alias: scope.metamodelTable.allTables[scope.metamodelTable.tableInformation.selected].columns[scope.metamodelTable.tableInformation.selected].alias,
                column: scope.metamodelTable.allTables[scope.metamodelTable.tableInformation.selected].columns[scope.metamodelTable.tableInformation.selected].column,
                table: scope.metamodelTable.tableInformation.selected,
                isPrimKey: true,
                type: scope.metamodelTable.allTables[scope.metamodelTable.tableInformation.selected].columns[scope.metamodelTable.tableInformation.selected].type,
                typeFormat: scope.metamodelTable.allTables[scope.metamodelTable.tableInformation.selected].columns[scope.metamodelTable.tableInformation.selected].typeFormat,
                description: scope.metamodelTable.allTables[scope.metamodelTable.tableInformation.selected].columns[scope.metamodelTable.tableInformation.selected].description,
                logical: scope.metamodelTable.allTables[scope.metamodelTable.tableInformation.selected].columns[scope.metamodelTable.tableInformation.selected].logical
            };

            semossCoreService.emit('alert', {
                color: 'success',
                text: 'Columns changes saved'
            });

            cancelTable();
        }

        /** Helpers */
        /**
         * @name initialize
         * @desc initialize the module
         * @returns {void}
         */
        function initialize() {
            $timeout(function () {
                scope.$watch(function () {
                    return JSON.stringify(scope.metamodelTable.metamodel);
                }, function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        setTable();
                    }
                });

                setTable();
            });
        }

        initialize();
    }
}
