'use strict';

export default angular.module('app.home.home-intro', [])
    .directive('homeIntro', homeIntroDirective);

import './home-intro.scss';

homeIntroDirective.$inject = ['$state', 'semossCoreService'];

function homeIntroDirective($state, semossCoreService) {
    homeIntroCtrl.$inject = [];
    homeIntroLink.$inject = ['scope', 'ele'];

    return {
        restrict: 'E',
        template: require('./home-intro.directive.html'),
        scope: {},
        controller: homeIntroCtrl,
        controllerAs: 'homeIntro',
        bindToController: {},
        link: homeIntroLink
    };
    function homeIntroCtrl() {}

    function homeIntroLink(scope, ele) {
        scope.homeIntro.open = false;
        scope.homeIntro.url = '';

        scope.homeIntro.action = action;
        scope.homeIntro.openIntro = openIntro;
        scope.homeIntro.closeIntro = closeIntro;

        /**
         * @name action
         * @param {string} type - type of action to perform
         * @desc peformn an action based on the help optoins
         * @returns {void}
         */
        function action(type) {
            if (type === 'tour') {
                semossCoreService.emit('start-tour', {
                    selectedState: $state.current.name,
                    selectedApp: semossCoreService.app.get('selectedApp')
                });
            } else if (type === 'github') {
                window.open('https://github.com/SEMOSS/Demo-Data', '_blank');
            }

            closeIntro();
        }

        /**
         * @name openIntro
         * @desc open the intro
         * @returns {void}
         */
        function openIntro() {
            scope.homeIntro.open = true;
            scope.homeIntro.url = 'https://www.youtube.com/embed/AA72vgwhKjI';
        }

        /**
         * @name closeIntro
         * @desc close the intro and stop playing the videos
         * @returns {void}
         */
        function closeIntro() {
            let overlayVideoEle = ele[0].querySelector('#home-intro__howto'),
                iframeSrc;

            scope.homeIntro.open = false;

            if (overlayVideoEle) {
                iframeSrc = overlayVideoEle.src;
                overlayVideoEle.src = iframeSrc;
            }
        }


        /**
         * @name initialize
         * @desc function that is called on directive load
         * @returns {void}
         */
        function initialize() {
            let openIntroListener,
                closeIntroListener,
                firstTime;

            openIntroListener = semossCoreService.on('open-intro', openIntro);
            closeIntroListener = semossCoreService.on('close-intro', closeIntro);
            // remove
            scope.$on('$destroy', function () {
                close();
                openIntroListener();
                closeIntroListener();
            });

            firstTime = window.localStorage.getItem('SMSSIntro');
            // if (firstTime === null) {
            //     window.localStorage.setItem('SMSSIntro', true);
            //     open();
            // }
        }

        initialize();
    }
}