'use strict';

import angular from 'angular';

export default angular.module('app.home.home-crumbs', [])
    .directive('homeCrumbs', homeCrumbsDirective);

import './home-crumbs.scss';

homeCrumbsDirective.$inject = ['$state', '$stateParams', '$transitions', 'semossCoreService'];

function homeCrumbsDirective($state, $stateParams, $transitions, semossCoreService) {
    homeCrumbsCtrl.$inject = [];
    homeCrumbsLink.$inject = ['scope'];

    return {
        restrict: 'E',
        template: require('./home-crumbs.directive.html'),
        scope: {},
        controller: homeCrumbsCtrl,
        controllerAs: 'homeCrumbs',
        bindToController: {},
        link: homeCrumbsLink
    };

    function homeCrumbsCtrl() { }

    function homeCrumbsLink(scope) {

        scope.homeCrumbs.navigation = {
            crumbs: [],
            selected: ''
        };

        scope.homeCrumbs.navigate = navigate;

        /**
         * @name navigate
         * @param state - selected state
         * @param params - params to pass to the state
         * @desc function that switches the view
         * @returns {void}
         */
        function navigate(state: string, params?: {}): void {
            $state.go(state, params || {});
        }

        /**
         * @name updateNavigation
         * @desc called when a route changes
         * @returns {void}
         */
        function updateNavigation(): void {
            let current = $state.current.name,
                crumb: { name: string, image: string, state: string, params: any, options: any[] } | undefined;

            // build the crumbs
            scope.homeCrumbs.navigation.crumbs = [];

            if (current.lastIndexOf('home.app') === 0) {
                const available = semossCoreService.app.get('available'),
                    selected = semossCoreService.app.getApp($stateParams.app);

                crumb = {
                    name: selected.name,
                    image: selected.image,
                    state: 'home.app',
                    params: {
                        app: selected.app_id
                    },
                    options: []
                };


                for (let app in available) {
                    if (available.hasOwnProperty(app)) {
                        if (available[app].app_id !== selected.app_id) {
                            crumb.options.push({
                                name: available[app].name,
                                image: available[app].image,
                                state: 'home.app',
                                params: {
                                    app: available[app].app_id
                                }
                            })
                        }
                    }
                }

            } else if (current.lastIndexOf('home.admin') === 0) {
                crumb = {
                    name: 'Settings',
                    image: '',
                    state: 'home.admin',
                    params: {},
                    options: []
                };
            } else if (current.lastIndexOf('home.build') === 0) {
                const selected = semossCoreService.getShared($stateParams.insight),
                    shared = semossCoreService.get('shared');

                crumb = {
                    name: selected.insight && selected.insight.name ? selected.insight.name : 'New Insight',
                    image: '',
                    state: 'home.build',
                    params: {
                        insight: selected.insightID
                    },
                    options: []
                };

                for (let insight in shared) {
                    if (shared.hasOwnProperty(insight)) {
                        if (shared[insight].insightID !== selected.insightID) {
                            crumb.options.push({
                                name: shared[insight].insight && shared[insight].insight.name ? shared[insight].insight.name : 'New Insight',
                                image: '',
                                state: 'home.build',
                                params: {
                                    insight: shared[insight].insightID
                                }
                            })
                        }
                    }
                }
            }

            if (crumb) {
                scope.homeCrumbs.navigation.crumbs.push(crumb)
            }
        }

        /**
         * @name initialize
         * @desc function that is called on directive load
         * @returns {void}
         */
        function initialize() {
            let navigationListener = $transitions.onSuccess({}, updateNavigation);;

            // remove
            scope.$on('$destroy', function () {
                navigationListener();
            });

            updateNavigation();
        }

        initialize();
    }
}