'use strict';

/**
 * @name app.directive.js
 * @desc app directive that serves as the main workspace of SEMOSS.
 */

export default angular.module('app.app.directive', [])
    .directive('app', appDirective);

appDirective.$inject = ['$transitions', '$state', '$stateParams'];

function appDirective($transitions, $state, $stateParams) {
    appLink.$inject = ['scope'];

    return {
        restrict: 'E',
        template: require('./app.directive.html'),
        link: appLink,
        scope: {}
    };

    function appLink(scope) {
        scope.app = {};
        scope.app.getContent = getContent;

        /**
         * @name updateNavigation
         * @desc called when the navigation information changes
         * @returns {void}
         */
        function updateNavigation() {
            scope.app.appId = $stateParams.app;
        }

        /**
         * @name getContent
         * @desc get the content to paint
         * @returns {void}
         */
        function getContent() {
            return '<app-home id="app-' + scope.app.appId + '" app-id="app.appId"></app-home>';
        }


        /**
         * @name initialize
         * @desc function that is called on directive load
         * @returns {void}
         */
        function initialize() {
            const navigationListener = $transitions.onSuccess({}, updateNavigation);

            scope.$on('$destroy', function () {
                navigationListener();
            });

            updateNavigation();
        }

        initialize();
    }
}
