/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.google.webapp;

import java.util.HashSet;
import org.semispace.SemiSpaceInterface;
import org.semispace.google.transport.AddressQuery;
import org.semispace.google.transport.GoogleAddress;
import org.semispace.google.webapp.beans.GoogleKey;
import org.semispace.google.webapp.beans.Token;
import org.semispace.google.webapp.beans.UserAuthBean;
import org.semispace.google.webapp.beans.UserList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class GoogledController {
    private static final Logger log = LoggerFactory.getLogger(GoogledController.class);
    private static final long DURATION_TEN_YEARS = 315360000000L;
    @Autowired
    private SemiSpaceInterface space;

    @RequestMapping(value={"/index.html"})
    public String entryPage() {
        return "entry";
    }

    @ModelAttribute(value="googleKey")
    public GoogleKey googleKey() {
        GoogleKey key = new GoogleKey();
        if (this.space.readIfExists((Object)key) == null) {
            return key;
        }
        return null;
    }

    @ModelAttribute(value="user")
    public UserAuthBean user() {
        return new UserAuthBean();
    }

    @ModelAttribute(value="userList")
    public UserList userList() {
        UserList userList = (UserList)this.space.read((Object)new UserList(), 750L);
        if (userList == null) {
            log.info("Creating new userlist as it was not present.");
            userList = new UserList();
            userList.setUsers(new HashSet());
            this.space.write((Object)userList, 315360000000L);
        }
        return userList;
    }

    @ModelAttribute(value="searchForAddress")
    public AddressQuery address() {
        return new AddressQuery();
    }

    @RequestMapping(value={"/submitAddress.html"})
    public ModelAndView submitAddress(@ModelAttribute AddressQuery query) {
        this.space.write((Object)query, 5000L);
        GoogleAddress ga = new GoogleAddress();
        ga.setAddress(query.getAddress());
        ga = (GoogleAddress)this.space.read((Object)ga, 5500L);
        ModelAndView mv = new ModelAndView("entry");
        mv.addObject("addressResult", (Object)ga);
        return mv;
    }

    @RequestMapping(value={"/submitUser.html"})
    public RedirectView submitUser(@ModelAttribute UserAuthBean user) {
        UserAuthBean template = new UserAuthBean();
        template.setUsername(user.getUsername());
        this.space.takeIfExists((Object)template);
        Token token = new Token();
        token.setUsername(user.getUsername());
        if (this.space.takeIfExists((Object)token) == null) {
            log.debug("Did not remove token for user " + token.getUsername());
        } else {
            log.info("Removed token for user " + token.getUsername());
        }
        UserList userList = (UserList)this.space.take((Object)new UserList(), 500L);
        UserList seldom = (UserList)this.space.takeIfExists((Object)new UserList());
        while (seldom != null) {
            log.warn("Notice: The space has obviously responded slowly at some time, and I therefore need to collate results");
            userList.getUsers().addAll(seldom.getUsers());
            seldom = (UserList)this.space.takeIfExists((Object)new UserList());
        }
        userList.getUsers().remove(user.getUsername());
        if (user.getPassword() != null && !"".equals(user.getPassword().trim())) {
            userList.getUsers().add(user.getUsername());
            this.space.write((Object)user, 315360000000L);
            log.debug("Added user " + user.getUsername());
        }
        this.space.write((Object)userList, 315360000000L);
        return new RedirectView("index.html");
    }

    @RequestMapping(value={"/submitGoogleKey.html"})
    public RedirectView submitGoogleKey(@ModelAttribute GoogleKey key) {
        GoogleKey template = new GoogleKey();
        this.space.takeIfExists((Object)template);
        this.space.write((Object)key, 315360000000L);
        return new RedirectView("index.html");
    }

    @RequestMapping(value={"/removeKey.html"})
    public RedirectView removeGoogleKey() {
        GoogleKey template = new GoogleKey();
        this.space.takeIfExists((Object)template);
        return new RedirectView("index.html");
    }
}

