/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.google.space.address;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.semispace.SemiEventListener;
import org.semispace.SemiEventRegistration;
import org.semispace.SemiSpaceInterface;
import org.semispace.event.SemiAvailabilityEvent;
import org.semispace.event.SemiEvent;
import org.semispace.google.space.address.AddressLookupSemaphore;
import org.semispace.google.space.address.FetchAddress;
import org.semispace.google.transport.AddressQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class GoogleAddressFetcher
implements DisposableBean,
SemiEventListener {
    private static final Logger log = LoggerFactory.getLogger(GoogleAddressFetcher.class);
    protected static final long TEN_YEARS = 315360000000L;
    private SemiEventRegistration lease = null;
    private SemiSpaceInterface space;
    private int simultanousLookups;
    private ExecutorService threadPool;

    public int getSimultanousLookups() {
        return this.simultanousLookups;
    }

    public void setSimultanousLookups(int simultanousLookups) {
        this.simultanousLookups = simultanousLookups;
    }

    public void setSpace(SemiSpaceInterface space) {
        this.space = space;
    }

    public void init() {
        log.debug("Initializing " + this.getClass().getName());
        this.threadPool = Executors.newCachedThreadPool();
        if (this.simultanousLookups < 1) {
            throw new RuntimeException("Configuration error - need to configure field simultanousLookups to a value greater than 0.");
        }
        this.resetSemaphores();
        if (this.lease != null) {
            log.warn("Double initialization? Strange.");
            this.lease.getLease().cancel();
        }
        this.lease = this.space.notify((Object)new AddressQuery(), (SemiEventListener)this, 315360000000L);
    }

    private void resetSemaphores() {
        while (this.space.takeIfExists((Object)new AddressLookupSemaphore()) != null) {
        }
        for (int i = 0; i < this.simultanousLookups; ++i) {
            this.space.write((Object)new AddressLookupSemaphore(), 315360000000L);
        }
    }

    public void destroy() throws Exception {
        if (this.lease != null) {
            this.lease.getLease().cancel();
        }
    }

    public void notify(SemiEvent theEvent) {
        if (theEvent instanceof SemiAvailabilityEvent) {
            if (this.space.readIfExists((Object)new AddressQuery()) == null) {
                log.warn("Could not read element even when getting availability in " + this + " Incoming event: " + theEvent.getClass().getName() + " #" + theEvent.getId());
            } else {
                log.info("Object read OK in " + this);
            }
            this.spawnThreadToTakeCareOfQuery();
        }
    }

    private void spawnThreadToTakeCareOfQuery() {
        this.threadPool.execute((Runnable)new FetchAddress(this.space));
    }
}

