/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.google.space.address;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.semispace.SemiSpaceInterface;
import org.semispace.google.space.address.AddressLookupSemaphore;
import org.semispace.google.transport.AddressQuery;
import org.semispace.google.transport.GoogleAddress;
import org.semispace.google.webapp.beans.GoogleKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchAddress
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FetchAddress.class);
    private static final long MAX_SEMAPHORE_WAIT_MS = 10000L;
    private SemiSpaceInterface space;

    public FetchAddress(SemiSpaceInterface space) {
        this.space = space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AddressQuery query = (AddressQuery)this.space.takeIfExists((Object)new AddressQuery());
        if (query == null) {
            log.warn("Could not get address query even when space flagged availability. Just returning.");
            return;
        }
        log.info("Read query OK in thread.");
        GoogleAddress ga = new GoogleAddress();
        ga.setAddress(query.getAddress());
        if (this.space.readIfExists((Object)ga) != null) {
            log.info("I alreay have a cached instance of the query for address, and will not query again: " + ga.getAddress());
            return;
        }
        AddressLookupSemaphore semaphore = (AddressLookupSemaphore)this.space.take((Object)new AddressLookupSemaphore(), 10000L);
        if (semaphore == null) {
            log.warn("Service seems to be saturated. Did not get semaphore.");
            return;
        }
        try {
            GoogleKey key = (GoogleKey)this.space.readIfExists((Object)new GoogleKey());
            if (key == null) {
                log.warn("Google key is null. You need to supply a valid key.");
                ga = new GoogleAddress();
                ga.setAccuracy("-2");
                ga.setAddress("-- missing google key on server --");
                this.space.write((Object)ga, 3600000L);
            } else {
                ga = this.resolveAddress(query.getAddress(), key);
                this.space.write((Object)ga, 86400000L);
                log.debug("Resolving " + ga.getAddress() + " resulted in status code " + ga.getStatusCode() + " and accuracy " + ga.getAccuracy());
            }
        }
        finally {
            this.space.write((Object)semaphore, 315360000000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleAddress resolveAddress(String address, GoogleKey key) {
        GoogleAddress result = new GoogleAddress();
        String url = this.encodeAddressAsHttpParameter(address, key);
        log.debug("Query url: " + url);
        GetMethod method = new GetMethod(url);
        try {
            result.setAddress(address);
            HttpClient client = new HttpClient();
            method.setFollowRedirects(false);
            method.setDoAuthentication(false);
            client.executeMethod((HttpMethod)method);
            byte[] buffer = method.getResponseBody();
            this.fillResponseInAddress(result, new String(buffer));
        }
        catch (IOException e) {
            result.setStatusCode("-1");
            log.error("Got exception", (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    private void fillResponseInAddress(GoogleAddress result, String csv) {
        log.debug("CSV from google: " + csv);
        String[] values = csv.split(",");
        result.setStatusCode(values[0]);
        result.setAccuracy(values[1]);
        result.setLatitude(values[2]);
        result.setLongitude(values[3]);
    }

    private String encodeAddressAsHttpParameter(String address, GoogleKey key) {
        StringBuilder sb = new StringBuilder();
        sb.append("http://maps.google.com/maps/geo?q=");
        try {
            sb.append(URLEncoder.encode(address, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("Got exception", (Throwable)e);
        }
        sb.append("&gl=no&output=csv&");
        sb.append("key=" + key.getKey());
        return sb.toString();
    }
}

