/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.google.space;

import java.util.Random;
import org.semispace.SemiSpaceInterface;
import org.semispace.google.webapp.beans.Token;
import org.semispace.google.webapp.beans.UserAuthBean;
import org.semispace.ws.TokenAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleSpaceAuthenticator
implements TokenAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(GoogleSpaceAuthenticator.class);
    private SemiSpaceInterface space;
    private final Random wheel = new Random();
    private static final long DEFAULT_SESSION_LENGTH = 1800000L;

    public void setSpace(SemiSpaceInterface space) {
        this.space = space;
    }

    public String authenticate(String username, String password) {
        UserAuthBean auth = new UserAuthBean();
        auth.setUsername(username);
        auth.setPassword(password);
        UserAuthBean result = (UserAuthBean)this.space.readIfExists((Object)auth);
        if (result != null) {
            Token tokenQuery = new Token();
            tokenQuery.setUsername(username);
            while (this.space.takeIfExists((Object)tokenQuery) != null) {
                log.debug("Removed existing token for user " + username);
            }
            String token = this.generateToken();
            tokenQuery.setToken(token);
            this.space.write((Object)tokenQuery, 1800000L);
            return token;
        }
        log.debug("User with user name " + username + " is not registered as user in space.");
        return null;
    }

    private String generateToken() {
        String rnd = Long.toString(this.wheel.nextLong() & Long.MAX_VALUE, 36);
        if (rnd.length() > 7) {
            rnd = rnd.substring(0, 7);
        }
        return rnd;
    }

    public boolean isTokenValid(String token) {
        Token tokenQuery = new Token();
        tokenQuery.setToken(token);
        tokenQuery = (Token)this.space.take((Object)tokenQuery, 200L);
        if (tokenQuery != null) {
            this.space.write((Object)tokenQuery, 1800000L);
            return true;
        }
        return false;
    }
}

