/*
 * Decompiled with CFR 0.152.
 */
package org.semanticwb.xmlrpc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.semanticwb.Logger;
import org.semanticwb.SWBUtils;
import org.semanticwb.xmlrpc.Part;
import org.semanticwb.xmlrpc.RPCFilter;
import org.semanticwb.xmlrpc.Response;
import org.semanticwb.xmlrpc.WBFileUpload;
import org.semanticwb.xmlrpc.XmlRpcDescription;
import org.semanticwb.xmlrpc.XmlRpcException;
import org.semanticwb.xmlrpc.XmlRpcMethod;
import org.semanticwb.xmlrpc.XmlRpcObject;
import org.semanticwb.xmlrpc.XmlRpcParam;
import org.semanticwb.xmlrpc.XmlRpcReturns;
import org.semanticwb.xmlrpc.XmlRpcSerializer;

public abstract class XMLRPCServlet
extends HttpServlet {
    private static String boundary = "gc0p4Jq0M2Yt08jU534c0p";
    private static Logger log = SWBUtils.getLogger(XMLRPCServlet.class);
    private static final String RETURN = "\r\n";
    private static String PREFIX_PROPERTY_PATH = "org.semanticwb.xmlrpc.";
    private static final String XMLRPC_DOCUMENT = "xmlrpc";
    private static final Set<RPCFilter> filters = Collections.synchronizedSet(new HashSet());

    public void init(String path) {
        PREFIX_PROPERTY_PATH = path;
        try {
            super.init();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public void addFilter(RPCFilter filter) {
        filters.add(filter);
    }

    public void removeFilter(RPCFilter filter) {
        filters.remove(filter);
    }

    public void clear() {
        filters.clear();
    }

    public void doWDSL(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Document docResponse = new Document();
        response.setContentType("text/xml;charset=utf-8");
        HashMap<String, Object> elements = new HashMap<String, Object>();
        Enumeration<Object> names = System.getProperties().keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            String value = System.getProperty(name);
            if (name == null || !name.startsWith(PREFIX_PROPERTY_PATH)) continue;
            String key = name.substring(PREFIX_PROPERTY_PATH.length());
            elements.put(key, value);
        }
        Element definitions = new Element("wsdl");
        docResponse.addContent((Content)definitions);
        for (String mapping : elements.keySet()) {
            String clazz = (String)elements.get(mapping);
            this.addClass(clazz, mapping, definitions);
        }
        ServletOutputStream out = response.getOutputStream();
        XMLOutputter xMLOutputter = new XMLOutputter();
        String xml = xMLOutputter.outputString(docResponse);
        out.write(xml.getBytes("utf-8"));
        out.flush();
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("wsdl") != null) {
            this.doWDSL(request, response);
        } else {
            super.doGet(request, response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Document xmlrpcDocument;
            HashSet<Part> parts = new HashSet<Part>();
            if (XMLRPCServlet.isMultipart(request)) {
                WBFileUpload upload = new WBFileUpload();
                upload.getFiles(request);
                for (String name : upload.getFileNames()) {
                    if (name.equals(XMLRPC_DOCUMENT)) continue;
                    byte[] content = upload.getFileData(name);
                    Part part = new Part(content, name, upload.getFileName(name));
                    parts.add(part);
                }
                xmlrpcDocument = XMLRPCServlet.getDocument(upload.getFileData(XMLRPC_DOCUMENT));
            } else {
                xmlrpcDocument = XMLRPCServlet.getDocument(request);
                XMLRPCServlet.writeDocumentToConsole(xmlrpcDocument);
            }
            try {
                for (RPCFilter filter : filters) {
                    filter.doFilter(xmlrpcDocument);
                }
                String methodName = XMLRPCServlet.getMethodName(xmlrpcDocument);
                ArrayList<Method> methods = XMLRPCServlet.getMethods(methodName);
                Object[] parameters = XmlRpcSerializer.deserializeRequest((Document)xmlrpcDocument, methods);
                Method method = XMLRPCServlet.getMethod(methodName, methods, parameters);
                String objectName = method.getDeclaringClass().getName();
                String user = "";
                String pass = "";
                if (request.getAttribute("user") != null) {
                    user = request.getAttribute("user").toString();
                }
                if (request.getAttribute("password") != null) {
                    pass = request.getAttribute("password").toString();
                }
                Response objResponse = this.execute(objectName, method, parameters, parts, user, pass);
                Document docResponse = XmlRpcSerializer.serializeResponse((Object)objResponse.getObject());
                XMLRPCServlet.sendResponse((ServletResponse)response, docResponse, objResponse);
            }
            catch (Exception cne) {
                try {
                    Document docResponse = XMLRPCServlet.getException(cne);
                    XMLRPCServlet.sendResponse((ServletResponse)response, docResponse);
                }
                catch (IOException ioeSendResponse) {
                    Document docResponse = XMLRPCServlet.getException(ioeSendResponse);
                    XMLRPCServlet.sendResponse((ServletResponse)response, docResponse);
                }
            }
        }
        catch (Exception jde) {
            try {
                Document docResponse = XMLRPCServlet.getException(jde);
                XMLRPCServlet.sendResponse((ServletResponse)response, docResponse);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
        }
    }

    private static void writeDocumentToConsole(Document document) {
        try {
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-8");
            XMLOutputter xMLOutputter = new XMLOutputter(format);
            xMLOutputter.output(document, (OutputStream)System.out);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    protected void beforeExecute(Object objToExecute, Set<Part> parts, String user, String password) throws Exception {
        if (objToExecute instanceof XmlRpcObject) {
            XmlRpcObject xmlRpcObject = (XmlRpcObject)objToExecute;
            xmlRpcObject.init(this.getServletConfig());
            xmlRpcObject.setUser(user);
            xmlRpcObject.setPassword(password);
            xmlRpcObject.setRequestParts(parts);
        }
    }

    protected void afterExecute(Object objToExecute) {
        if (objToExecute instanceof XmlRpcObject) {
            XmlRpcObject xmlRpcObject = (XmlRpcObject)objToExecute;
            xmlRpcObject.clearRequestParts();
        }
    }

    private static Method getMethod(String methodName, ArrayList<Method> methods, Object[] parameters) throws NoSuchMethodException {
        for (Method m : methods) {
            if (m.getParameterTypes().length != parameters.length) continue;
            return m;
        }
        throw new NoSuchMethodException("The method " + methodName + " was not found");
    }

    private static void sendPart(byte[] content, String name, String filename, OutputStream out) throws IOException {
        String newBoundary = "\r\n--" + boundary + RETURN;
        String contentDisposition = "Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + filename + "\"\r\n\r\n";
        out.write(newBoundary.getBytes());
        out.write(contentDisposition.getBytes());
        out.write(content);
    }

    private static void writeEnd(OutputStream out) throws IOException {
        String newBoundary = "\r\n--" + boundary + RETURN;
        out.write(newBoundary.getBytes());
    }

    private static void sendXmlDocumentPart(Document requestDoc, OutputStream out) throws IOException {
        String newBoundary = "--" + boundary + RETURN;
        String contentDisposition = "Content-Disposition: form-data; name=\"xmlrpc\"; filename=\"xmlrpc.xml\"\r\n\r\n";
        out.write(newBoundary.getBytes());
        out.write(contentDisposition.getBytes());
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        XMLOutputter outp = new XMLOutputter(format);
        outp.output(requestDoc, out);
    }

    private static void sendResponse(ServletResponse response, Document docResponse, Response objToResponse) throws IOException {
        if (objToResponse.getResponseParts() == null || objToResponse.getResponseParts().isEmpty()) {
            response.setContentType("text/xml;charset=utf-8");
            ServletOutputStream out = response.getOutputStream();
            XMLOutputter xMLOutputter = new XMLOutputter();
            String xml = xMLOutputter.outputString(docResponse);
            out.write(xml.getBytes("utf-8"));
            out.flush();
            out.close();
        } else {
            response.setContentType("multipart/form-data; boundary=" + boundary);
            ServletOutputStream out = response.getOutputStream();
            XMLRPCServlet.sendXmlDocumentPart(docResponse, (OutputStream)out);
            for (Part attachment : objToResponse.getResponseParts()) {
                XMLRPCServlet.sendPart(attachment.getContent(), attachment.getName(), attachment.getFileName(), (OutputStream)out);
            }
            XMLRPCServlet.writeEnd((OutputStream)out);
            out.flush();
            out.close();
        }
    }

    private static void sendResponse(ServletResponse response, Document docResponse) throws IOException {
        response.setContentType("text/xml;charset=utf-8");
        ServletOutputStream out = response.getOutputStream();
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        XMLOutputter xMLOutputter = new XMLOutputter(format);
        xMLOutputter.output(docResponse, (OutputStream)out);
        out.flush();
        out.close();
    }

    private static String getClassFullPath(String objectName) throws ClassNotFoundException {
        String classFullPath = System.getProperty(PREFIX_PROPERTY_PATH + objectName, null);
        if (classFullPath == null) {
            throw new ClassNotFoundException("The class for the Object Name: " + objectName + " was not found");
        }
        return classFullPath;
    }

    private void addParam(Element methodName, Class type, String comment, String name) {
        this.addType(methodName, type, comment, "param", name);
    }

    private void addReturns(Element methodName, Class type, String comment) {
        this.addType(methodName, type, comment, "returns", null);
    }

    private void addType(Element methodName, Class type, String comment, String paramname, String name) {
        Element param = new Element(paramname);
        if (comment != null) {
            param.setAttribute("description", comment);
        }
        if (name != null) {
            param.setAttribute("name", name);
        }
        methodName.addContent((Content)param);
        String value = type.getCanonicalName();
        if (type.equals(String.class)) {
            value = "string";
        } else if (type.equals(Integer.class) || type.equals(Long.class) || type.getName().equals("int") || type.getName().equals("long")) {
            value = "int";
        } else if (type.equals(Boolean.class) || type.getName().equals("boolean")) {
            value = "boolean";
        } else if (type.equals(Double.class) || type.equals(Float.class) || type.getName().equals("double") || type.getName().equals("float")) {
            value = "double";
        } else if (type.equals(Void.class) || type.getName().equals("void")) {
            value = "void";
        } else if (type.isArray()) {
            value = "array";
            Class<?> _arrayIs = type.getComponentType();
            String commentStruct = null;
            this.addType(param, _arrayIs, commentStruct, "typeof", type.getComponentType().getSimpleName());
        } else if (type.equals(Date.class) || type.equals(Calendar.class)) {
            value = "dateTime.iso8601";
        } else {
            value = "struct";
            for (Field field : type.getDeclaredFields()) {
                Class<?> classField = field.getType();
                String commentfield = null;
                XmlRpcDescription description = field.getAnnotation(XmlRpcDescription.class);
                if (description != null) {
                    commentfield = description.description();
                }
                this.addType(param, classField, commentfield, "field", field.getName());
            }
        }
        param.setAttribute("type", value);
    }

    private Response execute(String objectName, Method method, Object[] parameters, Set<Part> parts, String user, String password) throws ClassNotFoundException, XmlRpcException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        Class<?> clazz = method.getDeclaringClass();
        Object objToExecute = clazz.newInstance();
        try {
            this.beforeExecute(objToExecute, parts, user, password);
        }
        catch (Exception e) {
            throw new XmlRpcException("The object can not be inizialited into the method setupObject, cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            Object objectToReturn = method.invoke(objToExecute, parameters);
            this.afterExecute(objToExecute);
            Response resp = null;
            resp = objToExecute instanceof XmlRpcObject ? new Response(objectToReturn, ((XmlRpcObject)objToExecute).responseParts) : new Response(objectToReturn);
            return resp;
        }
        catch (InvocationTargetException inte) {
            log.debug(inte.getTargetException());
            throw new XmlRpcException(inte.getTargetException().getLocalizedMessage(), inte.getTargetException());
        }
    }

    private static String getMethodName(Document document) throws XmlRpcException, JDOMException, ClassNotFoundException {
        try {
            Element methodNameElement = (Element)XPath.selectSingleNode((Object)document.getRootElement(), (String)"/methodCall/methodName");
            if (methodNameElement == null) {
                throw new XmlRpcException("The methodName tag was not found");
            }
            return methodNameElement.getText();
        }
        catch (XmlRpcException e) {
            log.error((Throwable)e);
            throw e;
        }
        catch (JDOMException e) {
            log.error((Throwable)e);
            throw e;
        }
    }

    private static ArrayList<Method> getMethods(String pCallMethod) throws XmlRpcException, JDOMException, ClassNotFoundException {
        String[] values = pCallMethod.split("\\.");
        if (values.length != 2) {
            throw new XmlRpcException("The callMethos is incorrect");
        }
        String objectName = values[0];
        String methodName = values[1];
        String classFullPath = XMLRPCServlet.getClassFullPath(objectName);
        Class<?> clazz = Class.forName(classFullPath);
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            methods.add(m);
        }
        return methods;
    }

    private static void addElement(Element element, String name, int value) throws JDOMException, IOException {
        Element emember = new Element("member");
        Element ename = new Element("name");
        ename.setText(name);
        Element evalue = new Element("value");
        Element eint = new Element("int");
        evalue.addContent((Content)eint);
        eint.setText(String.valueOf(value));
        element.addContent((Content)emember);
        emember.addContent((Content)ename);
        emember.addContent((Content)evalue);
    }

    private static void addElement(Element element, String name, String value) throws JDOMException, IOException {
        Element emember = new Element("member");
        Element ename = new Element("name");
        ename.setText(name);
        Element evalue = new Element("value");
        Element eint = new Element("string");
        eint.setText(value);
        evalue.addContent((Content)eint);
        element.addContent((Content)emember);
        emember.addContent((Content)ename);
        emember.addContent((Content)evalue);
    }

    private static Document getException(Exception e) throws JDOMException, IOException {
        StringBuilder messageError = new StringBuilder(e.getLocalizedMessage() + RETURN);
        for (StackTraceElement element : e.getStackTrace()) {
            messageError.append(element.toString()).append(RETURN);
        }
        if (e.getCause() != null) {
            messageError.append(" cause: \r\n");
            messageError.append(e.getCause().getLocalizedMessage()).append(RETURN);
            for (StackTraceElement element : e.getCause().getStackTrace()) {
                messageError.append(element.toString()).append(RETURN);
            }
        }
        Document doc = new Document();
        Element methodResponse = new Element("methodResponse");
        doc.addContent((Content)methodResponse);
        Element fault = new Element("fault");
        methodResponse.addContent((Content)fault);
        Element value = new Element("value");
        Element struct = new Element("struct");
        fault.addContent((Content)value);
        value.addContent((Content)struct);
        XMLRPCServlet.addElement(struct, "faultCode", e.hashCode());
        XMLRPCServlet.addElement(struct, "faultString", messageError.toString());
        log.debug((Throwable)e);
        return doc;
    }

    private static Document getDocument(byte[] document) throws JDOMException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(document);
        SAXBuilder builder = new SAXBuilder();
        return builder.build((InputStream)in);
    }

    private static Document getDocument(HttpServletRequest request) throws IOException, JDOMException {
        ServletInputStream in = request.getInputStream();
        SAXBuilder builder = new SAXBuilder();
        Document docToReturn = builder.build((InputStream)in);
        in.close();
        return docToReturn;
    }

    private static boolean isMultipart(HttpServletRequest request) {
        boolean isMultipart = false;
        if (request.getContentType().indexOf("multipart/form-data") != -1) {
            isMultipart = true;
        }
        return isMultipart;
    }

    public static void addMappingType(String objectName, Class clazz) {
        System.setProperty(PREFIX_PROPERTY_PATH + objectName, clazz.getName());
    }

    public static void addMappingType(Map<String, Class> mapType) {
        for (String objectName : mapType.keySet()) {
            Class clazz = mapType.get(objectName);
            XMLRPCServlet.addMappingType(objectName, clazz);
        }
    }

    private void addClass(String clazz, String mapping, Element definition) {
        try {
            Class<?> oclazz = Class.forName(clazz);
            for (Class<?> _interface : oclazz.getInterfaces()) {
                for (Method m : _interface.getDeclaredMethods()) {
                    XmlRpcDescription description;
                    if (Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers()) || !m.isAnnotationPresent(XmlRpcMethod.class)) continue;
                    XmlRpcMethod annotation = m.getAnnotation(XmlRpcMethod.class);
                    String name = annotation.methodName();
                    Element methodName = new Element("method");
                    if (m.isAnnotationPresent(XmlRpcDescription.class) && (description = m.getAnnotation(XmlRpcDescription.class)) != null) {
                        methodName.setAttribute("description", description.description());
                    }
                    methodName.setAttribute("name", name);
                    definition.addContent((Content)methodName);
                    int index = 0;
                    Element params = new Element("params");
                    methodName.addContent((Content)params);
                    for (Class<?> type : m.getParameterTypes()) {
                        Annotation[][] annotations = m.getParameterAnnotations();
                        String comment = null;
                        for (Annotation annotationparam : annotations[index]) {
                            if (!annotationparam.annotationType().equals(XmlRpcDescription.class)) continue;
                            XmlRpcDescription description2 = (XmlRpcDescription)annotationparam;
                            comment = description2.description();
                        }
                        String nameparam = null;
                        for (Annotation annotationparam : annotations[index]) {
                            if (!annotationparam.annotationType().equals(XmlRpcParam.class)) continue;
                            XmlRpcParam param = (XmlRpcParam)annotationparam;
                            nameparam = param.name();
                        }
                        this.addParam(params, type, comment, nameparam);
                        ++index;
                    }
                    Class<?> classReturn = m.getReturnType();
                    String commentReturns = null;
                    XmlRpcReturns xmlRpcReturns = m.getAnnotation(XmlRpcReturns.class);
                    if (xmlRpcReturns != null) {
                        commentReturns = xmlRpcReturns.returns();
                    }
                    this.addReturns(methodName, classReturn, commentReturns);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            log.error((Throwable)cnfe);
        }
    }
}

