/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeResponse;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromeWebElement
implements RenderedWebElement,
Locatable,
FindsByXPath,
FindsByLinkText,
FindsById,
FindsByName,
FindsByTagName,
FindsByClassName,
SearchContext {
    private final ChromeDriver parent;
    private final String elementId;

    public ChromeWebElement(ChromeDriver parent, String elementId) {
        this.parent = parent;
        this.elementId = elementId;
    }

    String getElementId() {
        return this.elementId;
    }

    ChromeResponse execute(String commandName, Object ... parameters) {
        return this.parent.execute(commandName, parameters);
    }

    public void dragAndDropBy(int moveRightBy, int moveDownBy) {
        throw new UnsupportedOperationException("Not yet supported in Chrome");
    }

    public void dragAndDropOn(RenderedWebElement element) {
        throw new UnsupportedOperationException("Not yet supported in Chrome");
    }

    public Point getLocation() {
        return (Point)this.parent.execute("getElementLocation", this).getValue();
    }

    public Dimension getSize() {
        return (Dimension)this.parent.execute("getElementSize", this).getValue();
    }

    public String getValueOfCssProperty(String propertyName) {
        return this.parent.execute("getElementValueOfCssProperty", this, propertyName).getValue().toString();
    }

    public boolean isDisplayed() {
        ChromeResponse r = this.execute("isElementDisplayed", this);
        return (Boolean)r.getValue();
    }

    public void clear() {
        this.parent.execute("clearElement", this);
    }

    public void click() {
        this.parent.execute("clickElement", this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public String getAttribute(String name) {
        Object value = this.execute("getElementAttribute", this, name).getValue();
        return value == null ? null : value.toString();
    }

    @Deprecated
    public String getElementName() {
        return this.getTagName();
    }

    public String getTagName() {
        return this.execute("getElementTagName", this).getValue().toString();
    }

    public String getText() {
        return this.execute("getElementText", this).getValue().toString();
    }

    public String getValue() {
        return this.execute("getElementValue", this).getValue().toString();
    }

    public boolean isEnabled() {
        return Boolean.parseBoolean(this.execute("isElementEnabled", this).getValue().toString());
    }

    public boolean isSelected() {
        return Boolean.parseBoolean(this.execute("isElementSelected", this).getValue().toString());
    }

    public void sendKeys(CharSequence ... keysToSend) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence seq : keysToSend) {
            builder.append(seq);
        }
        this.execute("sendElementKeys", this, builder.toString());
    }

    public void setSelected() {
        this.execute("setElementSelected", this);
    }

    public void submit() {
        this.execute("submitElement", this);
    }

    public boolean toggle() {
        return Boolean.parseBoolean(this.execute("toggleElement", this).getValue().toString());
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        return (Point)this.parent.execute("getElementLocationOnceScrolledIntoView", this).getValue();
    }

    public WebElement findElementByXPath(String using) {
        return this.parent.getElementFrom(this.execute("findChildElement", this, "xpath", using));
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.parent.getElementsFrom(this.execute("findChildElements", this, "xpath", using));
    }

    public WebElement findElementByLinkText(String using) {
        return this.parent.getElementFrom(this.execute("findChildElement", this, "link text", using));
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.parent.getElementFrom(this.execute("findChildElement", this, "partial link text", using));
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.parent.getElementsFrom(this.execute("findChildElements", this, "link text", using));
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.parent.getElementsFrom(this.execute("findChildElements", this, "partial link text", using));
    }

    public WebElement findElementById(String using) {
        return this.parent.getElementFrom(this.execute("findChildElement", this, "id", using));
    }

    public List<WebElement> findElementsById(String using) {
        return this.parent.getElementsFrom(this.execute("findChildElements", this, "id", using));
    }

    public WebElement findElementByName(String using) {
        return this.parent.getElementFrom(this.execute("findChildElement", this, "name", using));
    }

    public List<WebElement> findElementsByName(String using) {
        return this.parent.getElementsFrom(this.execute("findChildElements", this, "name", using));
    }

    public WebElement findElementByTagName(String using) {
        return this.parent.getElementFrom(this.execute("findChildElement", this, "tag name", using));
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.parent.getElementsFrom(this.execute("findChildElements", this, "tag name", using));
    }

    public WebElement findElementByClassName(String using) {
        return this.parent.getElementFrom(this.execute("findChildElement", this, "class name", using));
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.parent.getElementsFrom(this.execute("findChildElements", this, "class name", using));
    }

    public void hover() {
        this.execute("hoverElement", this);
    }

    public int hashCode() {
        return this.elementId.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        if (other instanceof WrapsElement) {
            other = ((WrapsElement)obj).getWrappedElement();
        }
        if (!(other instanceof ChromeWebElement)) {
            return false;
        }
        Object result = this.parent.executeScript("return arguments[0] === arguments[1]", this, other);
        return result != null && result instanceof Boolean && (Boolean)result != false;
    }
}

