/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.XPathLookupException;
import org.openqa.selenium.chrome.ChromeResponse;
import org.openqa.selenium.chrome.ChromeWebElement;
import org.openqa.selenium.chrome.FatalChromeException;
import org.openqa.selenium.remote.Command;

public class ChromeCommandExecutor {
    private final ServerSocket serverSocket;
    private volatile boolean listen = false;
    private boolean hadClient = false;
    private boolean hasClient = false;
    ListeningThread listeningThread;
    private Map<String, JsonCommand> nameToJson = new HashMap<String, JsonCommand>();

    public ChromeCommandExecutor(int port) {
        this.nameToJson.put("close", new JsonCommand("{request: 'close'}"));
        this.nameToJson.put("quit", new JsonCommand("QUIT"));
        this.nameToJson.put("get", new JsonCommand("{request: 'url', url: ?url}"));
        this.nameToJson.put("goBack", new JsonCommand("{request: 'goBack'}"));
        this.nameToJson.put("goForward", new JsonCommand("{request: 'goForward'}"));
        this.nameToJson.put("refresh", new JsonCommand("{request: 'refresh'}"));
        this.nameToJson.put("addCookie", new JsonCommand("{request: 'addCookie', cookie: ?cookie}"));
        this.nameToJson.put("getCookies", new JsonCommand("{request: 'getCookies'}"));
        this.nameToJson.put("getCookieNamed", new JsonCommand("{request: 'getCookieNamed', name: ?name}"));
        this.nameToJson.put("deleteAllCookies", new JsonCommand("{request: 'deleteAllCookies'}"));
        this.nameToJson.put("deleteCookie", new JsonCommand("{request: 'deleteCookie', name: ?name}"));
        this.nameToJson.put("findElement", new JsonCommand("{request: 'getElement', by: [?using, ?value]}"));
        this.nameToJson.put("findElements", new JsonCommand("{request: 'getElements', by: [?using, ?value]}"));
        this.nameToJson.put("findChildElement", new JsonCommand("{request: 'getElement', by: [{id: ?element, using: ?using, value: ?value}]}"));
        this.nameToJson.put("findChildElements", new JsonCommand("{request: 'getElements', by: [{id: ?element, using: ?using, value: ?value}]}"));
        this.nameToJson.put("clearElement", new JsonCommand("{request: 'clearElement', elementId: ?elementId}"));
        this.nameToJson.put("clickElement", new JsonCommand("{request: 'clickElement', elementId: ?elementId}"));
        this.nameToJson.put("hoverElement", new JsonCommand("{request: 'hoverElement', elementId: ?elementId}"));
        this.nameToJson.put("sendElementKeys", new JsonCommand("{request: 'sendElementKeys', elementId: ?elementId, keys: ?keys}"));
        this.nameToJson.put("submitElement", new JsonCommand("{request: 'submitElement', elementId: ?elementId}"));
        this.nameToJson.put("toggleElement", new JsonCommand("{request: 'toggleElement', elementId: ?elementId}"));
        this.nameToJson.put("getElementAttribute", new JsonCommand("{request: 'getElementAttribute', elementId: ?elementId, attribute: ?attribute}"));
        this.nameToJson.put("getElementLocationOnceScrolledIntoView", new JsonCommand("{request: 'getElementLocationOnceScrolledIntoView', elementId: ?elementId}"));
        this.nameToJson.put("getElementLocation", new JsonCommand("{request: 'getElementLocation', elementId: ?elementId}"));
        this.nameToJson.put("getElementSize", new JsonCommand("{request: 'getElementSize', elementId: ?elementId}"));
        this.nameToJson.put("getElementTagName", new JsonCommand("{request: 'getElementTagName', elementId: ?elementId}"));
        this.nameToJson.put("getElementText", new JsonCommand("{request: 'getElementText', elementId: ?elementId}"));
        this.nameToJson.put("getElementValue", new JsonCommand("{request: 'getElementValue', elementId: ?elementId}"));
        this.nameToJson.put("getElementValueOfCssProperty", new JsonCommand("{request: 'getElementValueOfCssProperty', elementId: ?elementId, css: ?property}"));
        this.nameToJson.put("isElementDisplayed", new JsonCommand("{request: 'isElementDisplayed', elementId: ?elementId}"));
        this.nameToJson.put("isElementEnabled", new JsonCommand("{request: 'isElementEnabled', elementId: ?elementId}"));
        this.nameToJson.put("isElementSelected", new JsonCommand("{request: 'isElementSelected', elementId: ?elementId}"));
        this.nameToJson.put("setElementSelected", new JsonCommand("{request: 'setElementSelected', elementId: ?elementId}"));
        this.nameToJson.put("switchToActiveElement", new JsonCommand("{request: 'switchToActiveElement'}"));
        this.nameToJson.put("switchToFrameByIndex", new JsonCommand("{request: 'switchToFrame', using: {index: ?index}}"));
        this.nameToJson.put("switchToFrameByName", new JsonCommand("{request: 'switchToFrame', using: {name: ?name}}"));
        this.nameToJson.put("switchToDefaultContent", new JsonCommand("{request: 'switchToDefaultContent'}"));
        this.nameToJson.put("getWindowHandle", new JsonCommand("{request: 'getWindowHandle'}"));
        this.nameToJson.put("getWindowHandles", new JsonCommand("{request: 'getWindowHandles'}"));
        this.nameToJson.put("switchToWindow", new JsonCommand("{request: 'switchToWindow', windowName: ?name}"));
        this.nameToJson.put("execute", new JsonCommand("EXECUTE"));
        this.nameToJson.put("getCurrentUrl", new JsonCommand("{request: 'getCurrentUrl'}"));
        this.nameToJson.put("getPageSource", new JsonCommand("{request: 'getPageSource'}"));
        this.nameToJson.put("getTitle", new JsonCommand("{request: 'getTitle'}"));
        try {
            this.serverSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        this.listen = true;
        this.listeningThread = new ListeningThread(this.serverSocket);
        this.listeningThread.start();
    }

    boolean hasClient() {
        return this.hasClient;
    }

    public ChromeResponse execute(Command command) throws IOException {
        this.sendCommand(command);
        return this.handleResponse(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(Command command) throws IOException {
        Socket socket;
        while ((socket = (Socket)this.listeningThread.sockets.peek()) == null) {
            if (this.hadClient && !this.hasClient) {
                throw new IllegalStateException("Cannot execute command without a client");
            }
            Thread.yield();
        }
        try {
            JsonCommand commandToPopulate = this.nameToJson.get(command.getMethodName());
            if (commandToPopulate == null) {
                throw new UnsupportedOperationException("Didn't know how to execute: " + command.getMethodName());
            }
            String commandStringToSend = commandToPopulate.populate(command.getParameters());
            socket.getOutputStream().write(this.fillTwoHundredWithJson(commandStringToSend));
            socket.getOutputStream().flush();
        }
        finally {
            socket.close();
            this.listeningThread.sockets.remove(socket);
        }
    }

    private byte[] fillTwoHundredWithJson(String message) {
        return this.fillTwoHundred(message, "application/json; charset=UTF-8");
    }

    private byte[] fillTwoHundred(String message, String contentType) {
        String httpMessage = "HTTP/1.1 200 OK\r\nContent-Length: " + message.length() + "\r\nContent-Type: " + contentType + "\r\n\r\n" + message;
        try {
            return httpMessage.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WebDriverException("Your environment doesn't support UTF-8");
        }
    }

    private ChromeResponse handleResponse(Command command) throws IOException {
        String line;
        Socket socket;
        while ((socket = (Socket)this.listeningThread.sockets.peek()) == null) {
            Thread.yield();
        }
        StringBuilder resultBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        boolean hasSeenDoubleCRLF = false;
        while ((line = reader.readLine()) != null && !line.equals("EOResponse")) {
            if (hasSeenDoubleCRLF) {
                if (resultBuilder.length() > 0) {
                    resultBuilder.append("\n");
                }
                resultBuilder.append(line);
            }
            if (!line.equals("")) continue;
            hasSeenDoubleCRLF = true;
        }
        return this.parseResponse(resultBuilder.toString());
    }

    private ChromeResponse parseResponse(String rawJsonString) {
        if (rawJsonString.length() == 0) {
            return new ChromeResponse(0, null);
        }
        try {
            JSONObject jsonObject = new JSONObject(rawJsonString);
            if (!jsonObject.has("statusCode")) {
                throw new WebDriverException("Response had no status code.  Response was: " + rawJsonString);
            }
            if (jsonObject.getInt("statusCode") == 0) {
                if (!jsonObject.has("value") || jsonObject.isNull("value")) {
                    return new ChromeResponse(0, null);
                }
                Object value = jsonObject.get("value");
                Object parsedValue = this.parseJsonToObject(value);
                if (parsedValue instanceof ChromeWebElement) {
                    return new ChromeResponse(-1, ((ChromeWebElement)parsedValue).getElementId());
                }
                return new ChromeResponse(0, parsedValue);
            }
            String message = "";
            if (jsonObject.has("value") && jsonObject.get("value") instanceof JSONObject && jsonObject.getJSONObject("value").has("message") && jsonObject.getJSONObject("value").get("message") instanceof String) {
                message = jsonObject.getJSONObject("value").getString("message");
            }
            switch (jsonObject.getInt("statusCode")) {
                case 2: {
                    throw new WebDriverException(message);
                }
                case 3: {
                    throw new NoSuchWindowException(message);
                }
                case 7: {
                    throw new NoSuchElementException(message);
                }
                case 8: {
                    throw new NoSuchFrameException(message);
                }
                case 9: {
                    throw new UnsupportedOperationException(message);
                }
                case 10: {
                    throw new StaleElementReferenceException(message);
                }
                case 11: {
                    throw new ElementNotVisibleException(message);
                }
                case 12: {
                    throw new UnsupportedOperationException(message);
                }
                case 17: {
                    throw new WebDriverException(message);
                }
                case 19: {
                    throw new XPathLookupException(message);
                }
                case 99: {
                    throw new WebDriverException("An error occured when sending a native event");
                }
                case 500: {
                    if (message.equals("")) {
                        message = "An error occured due to the internals of Chrome. This does not mean your test failed. Try running your test again in isolation.";
                    }
                    throw new FatalChromeException(message);
                }
            }
            throw new WebDriverException("An error occured in the page");
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Object parseJsonToObject(Object value) throws JSONException {
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)value;
            ArrayList<Object> arr = new ArrayList<Object>(jsonArray.length());
            for (int i = 0; i < jsonArray.length(); ++i) {
                arr.add(this.parseJsonToObject(jsonArray.get(i)));
            }
            return arr;
        }
        if (value instanceof JSONObject) {
            JSONObject object = (JSONObject)value;
            if (!object.has("type")) {
                throw new WebDriverException("Returned a JSONObjet which had no type");
            }
            if ("NULL".equals(object.getString("type"))) {
                return null;
            }
            if ("VALUE".equals(object.getString("type"))) {
                Object innerValue = object.get("value");
                if (innerValue instanceof Integer) {
                    innerValue = new Long(((Integer)innerValue).intValue());
                }
                return innerValue;
            }
            if ("ELEMENT".equals(object.getString("type"))) {
                return new ChromeWebElement(null, (String)object.get("value"));
            }
            if ("POINT".equals(object.getString("type"))) {
                if (!(object.has("x") && object.has("y") && object.get("x") instanceof Number && object.get("y") instanceof Number)) {
                    throw new WebDriverException("Couldn't construct Point without x and y coordinates");
                }
                return new Point(object.getInt("x"), object.getInt("y"));
            }
            if ("DIMENSION".equals(object.getString("type"))) {
                if (!(object.has("width") && object.has("height") && object.get("width") instanceof Number && object.get("height") instanceof Number)) {
                    throw new WebDriverException("Couldn't construct Dimension without width and height");
                }
                return new Dimension(object.getInt("width"), object.getInt("height"));
            }
            if ("COOKIE".equals(object.getString("type"))) {
                if (!object.has("name") || !object.has("value")) {
                    throw new WebDriverException("Couldn't construct Cookie without name and value");
                }
                return new Cookie(object.getString("name"), object.getString("value"));
            }
        } else {
            throw new WebDriverException("Didn't know how to deal with response value of type: " + value.getClass());
        }
        return null;
    }

    public void stopListening() {
        this.listen = false;
        this.listeningThread.stopListening();
        while (!this.serverSocket.isClosed()) {
            Thread.yield();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class JsonCommand {
        private final String json;

        JsonCommand(String json) {
            if (json == null) {
                throw new NullPointerException("JSON cannot be null in JsonCommand");
            }
            this.json = json;
        }

        public String populate(Object ... parameters) {
            if (this.json.equals("EXECUTE")) {
                JSONObject jsonObject;
                JsonCommand jsonCommand = new JsonCommand("{request: 'execute', script: ?script}");
                String populated = jsonCommand.populate(parameters[0]);
                try {
                    jsonObject = new JSONObject(populated);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                JSONArray args = new JSONArray();
                if (parameters.length > 1 && parameters[1].getClass().isArray()) {
                    Object[] argumentsFromParameters = (Object[])parameters[1];
                    for (int i = 0; i < argumentsFromParameters.length; ++i) {
                        args.put(JsonCommand.wrapArgumentForScriptExecution(argumentsFromParameters[i]));
                    }
                }
                try {
                    jsonObject.put("args", (Object)args);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                return jsonObject.toString();
            }
            List<String> parts = Arrays.asList(this.json.split(","));
            int i = 0;
            StringBuilder builder = new StringBuilder(this.json.length());
            Iterator<String> it = parts.iterator();
            while (it.hasNext()) {
                String part = it.next();
                String[] nameAndValue = part.split("\\?");
                builder.append(nameAndValue[0]);
                if (nameAndValue.length == 2) {
                    String parsedParameter;
                    if (i >= parameters.length) {
                        throw new IllegalArgumentException("More variables than parameters passed (" + parameters.length + ") when populating command");
                    }
                    String value = nameAndValue[1];
                    while (value.indexOf(93) > -1 || value.indexOf(125) > -1) {
                        if (value.indexOf(93) > -1) {
                            value = value.substring(0, value.indexOf(93));
                        }
                        if (value.indexOf(125) <= -1) continue;
                        value = value.substring(0, value.indexOf(125));
                    }
                    if (parameters[i] instanceof ChromeWebElement) {
                        parsedParameter = ((ChromeWebElement)parameters[i]).getElementId().replace("element/", "");
                    } else if (parameters[i] instanceof Cookie) {
                        Cookie cookie = (Cookie)parameters[i];
                        HashMap<String, Object> cookieMap = new HashMap<String, Object>();
                        cookieMap.put("name", cookie.getName());
                        cookieMap.put("value", cookie.getValue());
                        cookieMap.put("domain", cookie.getDomain());
                        cookieMap.put("path", cookie.getPath());
                        cookieMap.put("secure", cookie.isSecure());
                        cookieMap.put("expiry", cookie.getExpiry());
                        parsedParameter = new JSONObject(cookieMap).toString();
                    } else if (parameters[i].getClass().isArray()) {
                        try {
                            parsedParameter = new JSONArray(parameters[i]).toString();
                        }
                        catch (JSONException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        parsedParameter = parameters[i].toString();
                    }
                    parsedParameter = JsonCommand.sanitize(parsedParameter);
                    if (parameters[i] instanceof String) {
                        parsedParameter = "'" + parsedParameter + "'";
                    }
                    ++i;
                    String restOfValue = nameAndValue[1].substring(value.length());
                    builder.append(parsedParameter).append(restOfValue);
                }
                if (!it.hasNext()) continue;
                builder.append(",");
            }
            if (i != parameters.length) {
                throw new IllegalArgumentException("More parameters (" + parameters.length + ") than variables ( " + i + ") when populating command");
            }
            return builder.toString();
        }

        static Object wrapArgumentForScriptExecution(Object argument) {
            JSONObject wrappedArgument;
            block8: {
                wrappedArgument = new JSONObject();
                try {
                    if (argument instanceof String) {
                        wrappedArgument.put("type", (Object)"STRING");
                        wrappedArgument.put("value", argument);
                        break block8;
                    }
                    if (argument instanceof Boolean) {
                        wrappedArgument.put("type", (Object)"BOOLEAN");
                        wrappedArgument.put("value", argument);
                        break block8;
                    }
                    if (argument instanceof Number) {
                        wrappedArgument.put("type", (Object)"NUMBER");
                        wrappedArgument.put("value", argument);
                        break block8;
                    }
                    if (argument instanceof ChromeWebElement) {
                        wrappedArgument.put("type", (Object)"ELEMENT");
                        wrappedArgument.put("value", (Object)((ChromeWebElement)argument).getElementId());
                        break block8;
                    }
                    if (argument instanceof Collection) {
                        JSONArray array = new JSONArray();
                        for (Object o : (Collection)argument) {
                            array.put(JsonCommand.wrapArgumentForScriptExecution(o));
                        }
                        return array;
                    }
                    throw new IllegalArgumentException("Could not wrap up javascript parameter " + argument + "(class: " + argument.getClass() + ")");
                }
                catch (JSONException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
            return wrappedArgument;
        }

        static String sanitize(String string) {
            return string.replace("\\", "\\\\").replace("'", "\\'").replace("\n", "\\n");
        }
    }

    private class ListeningThread
    extends Thread {
        private boolean isListening = false;
        private Queue<Socket> sockets = new ConcurrentLinkedQueue<Socket>();
        private ServerSocket serverSocket;

        public ListeningThread(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        public void run() {
            if (!this.isListening) {
                this.listen();
            }
        }

        public void listen() {
            this.isListening = true;
            try {
                while (ChromeCommandExecutor.this.listen) {
                    this.sockets.add(this.serverSocket.accept());
                    ChromeCommandExecutor.this.hasClient = true;
                    ChromeCommandExecutor.this.hadClient = true;
                }
            }
            catch (SocketException e) {
                if (ChromeCommandExecutor.this.listen) {
                    throw new WebDriverException((Throwable)e);
                }
            }
            catch (IOException e) {
                this.isListening = false;
                throw new WebDriverException((Throwable)e);
            }
        }

        public void stopListening() {
            try {
                this.closeCurrentSockets();
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
            finally {
                try {
                    if (!this.serverSocket.isClosed()) {
                        this.serverSocket.close();
                    }
                }
                catch (Exception e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
        }

        private void closeCurrentSockets() {
            for (Socket socket : ChromeCommandExecutor.this.listeningThread.sockets) {
                try {
                    socket.close();
                    ChromeCommandExecutor.this.listeningThread.sockets.remove(socket);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

