/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.devtools;

import java.io.Closeable;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.idealized.Network;
import org.openqa.selenium.devtools.idealized.OpaqueKey;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;

public class NetworkInterceptor
implements Closeable {
    public static final HttpResponse PROCEED_WITH_REQUEST = (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Selenium-Interceptor", "Continue")).setContent(Contents.utf8String((CharSequence)"Original request should proceed"));
    private final OpaqueKey key;
    private final Network<?, ?> network;

    public NetworkInterceptor(WebDriver driver, Route route) {
        if (!(driver instanceof HasDevTools)) {
            throw new IllegalArgumentException("WebDriver instance must implement HasDevTools");
        }
        Require.nonNull((String)"Route", (Object)route);
        DevTools devTools = ((HasDevTools)driver).getDevTools();
        devTools.createSessionIfThereIsNotOne();
        this.network = devTools.getDomains().network();
        this.key = this.network.addRequestHandler((Routable)route);
    }

    @Override
    public void close() {
        this.network.removeRequestHandler(this.key);
    }
}

