/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.locators;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;

public class RelativeLocator {
    private static final Json JSON = new Json();
    private static final String FIND_ELEMENTS;

    public static RelativeBy withTagName(String tagName) {
        Require.nonNull((String)"Tag name to look for", (Object)tagName);
        return new RelativeBy((Object)By.tagName((String)tagName));
    }

    private static Object asAtomLocatorParameter(Object object) {
        if (object instanceof WebElement) {
            return object;
        }
        if (!(object instanceof By)) {
            throw new IllegalArgumentException("Expected locator to be either an element or a By: " + object);
        }
        RelativeLocator.assertLocatorCanBeSerialized(object);
        Map raw = (Map)JSON.toType(JSON.toJson(object), Json.MAP_TYPE);
        if (!(raw.get("using") instanceof String)) {
            throw new JsonException("Expected JSON encoded form of locator to have a 'using' field. " + raw);
        }
        if (!raw.containsKey("value")) {
            throw new JsonException("Expected JSON encoded form of locator to have a 'value' field: " + raw);
        }
        return ImmutableMap.of((Object)((String)raw.get("using")), raw.get("value"));
    }

    private static void assertLocatorCanBeSerialized(Object locator) {
        Require.nonNull((String)"Locator", (Object)locator);
        Class<?> clazz = locator.getClass();
        while (!clazz.equals(Object.class)) {
            try {
                clazz.getDeclaredMethod("toJson", new Class[0]);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new IllegalArgumentException("Locator must be serializable to JSON using a `toJson` method. " + locator);
    }

    static {
        try {
            String location = String.format("/%s/%s", RelativeLocator.class.getPackage().getName().replace(".", "/"), "findElements.js");
            URL url = RelativeLocator.class.getResource(location);
            String rawFunction = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            FIND_ELEMENTS = String.format("return (%s).apply(null, arguments);", rawFunction);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class RelativeBy
    extends By {
        private final Object root;
        private final List<Map<String, Object>> filters;

        private RelativeBy(Object rootLocator) {
            this(rootLocator, (List<Map<String, Object>>)ImmutableList.of());
        }

        private RelativeBy(Object rootLocator, List<Map<String, Object>> filters) {
            if (rootLocator instanceof By) {
                RelativeLocator.assertLocatorCanBeSerialized(rootLocator);
                rootLocator = RelativeLocator.asAtomLocatorParameter(rootLocator);
            } else if (rootLocator instanceof Map) {
                if (((Map)rootLocator).keySet().size() != 1) {
                    throw new IllegalArgumentException("Root locators as find element payload must only have a single key: " + rootLocator);
                }
            } else if (!(rootLocator instanceof WebElement)) {
                throw new IllegalArgumentException("Root locator must be an element or a locator: " + rootLocator);
            }
            this.root = Require.nonNull((String)"Root locator", (Object)rootLocator);
            this.filters = ImmutableList.copyOf((Collection)((Collection)Require.nonNull((String)"Filters", filters)));
        }

        public RelativeBy above(WebElement element) {
            Require.nonNull((String)"Element to search above of", (Object)element);
            return this.simpleDirection("above", element);
        }

        public RelativeBy above(By locator) {
            Require.nonNull((String)"Locator", (Object)locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("above", locator);
        }

        public RelativeBy below(WebElement element) {
            Require.nonNull((String)"Element to search below of", (Object)element);
            return this.simpleDirection("below", element);
        }

        public RelativeBy below(By locator) {
            Require.nonNull((String)"Locator", (Object)locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("below", locator);
        }

        public RelativeBy toLeftOf(WebElement element) {
            Require.nonNull((String)"Element to search to left of", (Object)element);
            return this.simpleDirection("left", element);
        }

        public RelativeBy toLeftOf(By locator) {
            Require.nonNull((String)"Locator", (Object)locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("left", locator);
        }

        public RelativeBy toRightOf(WebElement element) {
            Require.nonNull((String)"Element to search to right of", (Object)element);
            return this.simpleDirection("right", element);
        }

        public RelativeBy toRightOf(By locator) {
            Require.nonNull((String)"Locator", (Object)locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("right", locator);
        }

        public RelativeBy near(WebElement element) {
            Require.nonNull((String)"Element to search near", (Object)element);
            return this.near(element, 50);
        }

        public RelativeBy near(WebElement element, int atMostDistanceInPixels) {
            Require.nonNull((String)"Element to search near", (Object)element);
            Require.positive((String)"Distance", (Integer)atMostDistanceInPixels);
            return this.near((Object)element, atMostDistanceInPixels);
        }

        public RelativeBy near(By locator) {
            Require.nonNull((String)"Locator", (Object)locator);
            return this.near((Object)locator, 50);
        }

        public RelativeBy near(By locator, int atMostDistanceInPixels) {
            Require.nonNull((String)"Locator", (Object)locator);
            Require.positive((String)"Distance", (Integer)atMostDistanceInPixels);
            return this.near((Object)locator, atMostDistanceInPixels);
        }

        private RelativeBy near(Object locator, int atMostDistanceInPixels) {
            Require.nonNull((String)"Locator", (Object)locator);
            Require.positive((String)"Distance", (Integer)atMostDistanceInPixels);
            return new RelativeBy(this.root, this.amend((Map<String, Object>)ImmutableMap.of((Object)"kind", (Object)"near", (Object)"args", (Object)ImmutableList.of((Object)RelativeLocator.asAtomLocatorParameter(locator), (Object)"distance", (Object)atMostDistanceInPixels))));
        }

        public List<WebElement> findElements(SearchContext context) {
            JavascriptExecutor js = this.extractJsExecutor(context);
            List elements = (List)js.executeScript(FIND_ELEMENTS, new Object[]{this.toJson()});
            return elements;
        }

        private RelativeBy simpleDirection(String direction, Object locator) {
            Require.nonNull((String)"Direction to search in", (Object)direction);
            Require.nonNull((String)"Locator", (Object)locator);
            return new RelativeBy(this.root, this.amend((Map<String, Object>)ImmutableMap.of((Object)"kind", (Object)direction, (Object)"args", (Object)ImmutableList.of((Object)RelativeLocator.asAtomLocatorParameter(locator)))));
        }

        private List<Map<String, Object>> amend(Map<String, Object> toAdd) {
            return ImmutableList.builder().addAll(this.filters).add(toAdd).build();
        }

        private JavascriptExecutor extractJsExecutor(SearchContext context) {
            if (context instanceof JavascriptExecutor) {
                return (JavascriptExecutor)context;
            }
            SearchContext current = context;
            while (current instanceof WrapsDriver) {
                WebDriver driver = ((WrapsDriver)context).getWrappedDriver();
                if (driver instanceof JavascriptExecutor) {
                    return (JavascriptExecutor)driver;
                }
                current = driver;
            }
            throw new IllegalArgumentException("Cannot find elements, since the context cannot execute JS: " + context);
        }

        private Map<String, Object> toJson() {
            return ImmutableMap.of((Object)"relative", (Object)ImmutableMap.of((Object)"root", (Object)this.root, (Object)"filters", this.filters));
        }
    }
}

