/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import com.google.common.base.Throwables;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.listeners.TestSessionListener;
import org.openqa.grid.internal.utils.CapabilityMatcher;

public class TestSlot {
    private static final Logger log = Logger.getLogger(TestSlot.class.getName());
    private final Map<String, Object> capabilities;
    private final RemoteProxy proxy;
    private final SeleniumProtocol protocol;
    private final String path;
    private final CapabilityMatcher matcher;
    private final Lock lock = new ReentrantLock();
    private volatile TestSession currentSession;
    private volatile boolean beingReleased = false;
    private boolean showWarning = false;
    private long lastSessionStart = -1L;

    public TestSlot(RemoteProxy proxy, SeleniumProtocol protocol, String path, Map<String, Object> capabilities) {
        this.proxy = proxy;
        this.protocol = protocol;
        this.path = path;
        CapabilityMatcher c = proxy.getCapabilityHelper();
        if (c == null) {
            throw new InvalidParameterException("the proxy needs to have a valid capabilityMatcher to support have some test slots attached to it");
        }
        this.matcher = proxy.getCapabilityHelper();
        this.capabilities = capabilities;
    }

    public TestSlot(RemoteProxy proxy, SeleniumProtocol protocol, Map<String, Object> capabilities) {
        this(proxy, protocol, protocol.getPathConsideringCapabilitiesMap(capabilities), capabilities);
    }

    public Map<String, Object> getCapabilities() {
        return Collections.unmodifiableMap(this.capabilities);
    }

    public RemoteProxy getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestSession getNewSession(Map<String, Object> desiredCapabilities) {
        try {
            this.lock.lock();
            if (this.currentSession != null) {
                TestSession testSession = null;
                return testSession;
            }
            if (this.matches(desiredCapabilities)) {
                TestSession session;
                log.info("Trying to create a new session on test slot " + this.capabilities);
                desiredCapabilities.put("server:CONFIG_UUID", this.capabilities.get("server:CONFIG_UUID"));
                this.currentSession = session = new TestSession(this, desiredCapabilities, Clock.systemUTC());
                this.lastSessionStart = System.currentTimeMillis();
                TestSession testSession = session;
                return testSession;
            }
            TestSession testSession = null;
            return testSession;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SeleniumProtocol getProtocol() {
        return this.protocol;
    }

    public String getPath() {
        return this.path;
    }

    public boolean matches(Map<String, Object> desiredCapabilities) {
        return this.matcher.matches(this.capabilities, desiredCapabilities);
    }

    public TestSession getSession() {
        return this.currentSession;
    }

    public boolean startReleaseProcess() {
        if (this.currentSession == null) {
            return false;
        }
        try {
            this.lock.lock();
            if (this.beingReleased) {
                boolean bl = false;
                return bl;
            }
            this.beingReleased = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void finishReleaseProcess() {
        try {
            this.lock.lock();
            this.doFinishRelease();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void doFinishRelease() {
        this.currentSession = null;
        this.beingReleased = false;
    }

    public String getInternalKey() {
        return this.currentSession == null ? null : this.currentSession.getInternalKey();
    }

    public boolean performAfterSessionEvent() {
        try {
            if (this.proxy instanceof TestSessionListener) {
                if (this.showWarning && this.proxy.getMaxNumberOfConcurrentTestSessions() != 1) {
                    log.warning("WARNING : using a afterSession on a proxy that can support multiple tests is risky.");
                    this.showWarning = false;
                }
                ((TestSessionListener)((Object)this.proxy)).afterSession(this.currentSession);
            }
        }
        catch (Throwable t) {
            log.severe(String.format("Error running afterSession for %s, the test slot is now dead: %s\n%s", this.currentSession, t.getMessage(), Throwables.getStackTraceAsString((Throwable)t)));
            return false;
        }
        return true;
    }

    public String toString() {
        return this.currentSession == null ? "no session" : this.currentSession.toString();
    }

    public URL getRemoteURL() {
        String u = this.getProxy().getRemoteHost() + this.getPath();
        try {
            return new URL(u);
        }
        catch (MalformedURLException e) {
            throw new GridException("Configuration error for the node." + u + " isn't a valid URL");
        }
    }

    public long getLastSessionStart() {
        return this.lastSessionStart;
    }
}

