/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import com.google.common.base.Strings;
import io.opentracing.tag.Tags;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.tracing.Span;

public class HttpTracing {
    public static final Function<HttpRequest, Map<String, String>> AS_MAP = req -> {
        TreeMap<String, String> builder = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String name : req.getHeaderNames()) {
            String value;
            if (Strings.isNullOrEmpty((String)name) || Strings.isNullOrEmpty((String)(value = req.getHeader(name)))) continue;
            builder.put(name, value);
        }
        return Collections.unmodifiableMap(builder);
    };

    private HttpTracing() {
    }

    public static void inject(Span span, HttpRequest request) {
        Objects.requireNonNull(request, "Request must be set.");
        if (span == null) {
            return;
        }
        span.addTag(Tags.HTTP_METHOD.getKey(), request.getMethod().toString());
        span.addTag(Tags.HTTP_URL.getKey(), request.getUri());
        span.inject((x$0, x$1) -> request.setHeader(x$0, x$1));
    }
}

