/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.BaseRemoteProxy;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.selenium.json.Json;

public class RegistrationServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = -8670670577712086527L;
    private static final Logger log = Logger.getLogger(RegistrationServlet.class.getName());
    private static final Json JSON = new Json();

    public RegistrationServlet() {
        this(null);
    }

    public RegistrationServlet(GridRegistry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestJsonString;
        try (BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));){
            requestJsonString = CharStreams.toString((Readable)rd);
        }
        log.fine("getting the following registration request  : " + requestJsonString);
        Map json = (Map)JSON.toType(requestJsonString, Json.MAP_TYPE);
        if (!(json.get("configuration") instanceof Map)) {
            throw new GridConfigurationException("No configuration received for proxy.");
        }
        RegistrationRequest registrationRequest = RegistrationRequest.fromJson(json);
        Object proxy = BaseRemoteProxy.getNewInstance(registrationRequest, this.getRegistry());
        this.reply(response, "ok");
        new Thread(() -> {
            this.getRegistry().add((RemoteProxy)proxy);
            log.fine("proxy added " + proxy.getRemoteHost());
        }).start();
    }

    protected void reply(HttpServletResponse response, String content) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        response.getWriter().print(content);
    }
}

