/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium;

import com.beust.jcommander.JCommander;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.openqa.grid.common.GridRole;
import org.openqa.grid.internal.utils.SelfRegisteringRemote;
import org.openqa.grid.internal.utils.configuration.CoreRunnerConfiguration;
import org.openqa.grid.internal.utils.configuration.GridHubConfiguration;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.shared.Stoppable;
import org.openqa.grid.web.Hub;
import org.openqa.grid.web.servlet.DisplayHelpServlet;
import org.openqa.selenium.internal.BuildInfo;
import org.openqa.selenium.remote.server.SeleniumServer;
import org.openqa.selenium.remote.server.log.LoggingOptions;
import org.openqa.selenium.remote.server.log.TerseFormatter;

public class GridLauncherV3 {
    private static final Logger log = Logger.getLogger(GridLauncherV3.class.getName());
    private static final String CORE_RUNNER_CLASS = "org.openqa.selenium.server.htmlrunner.HTMLLauncher";
    private static final BuildInfo buildInfo = new BuildInfo();
    private PrintStream out;
    private String[] args;
    private static Map<String, Function<String[], GridItemLauncher>> LAUNCHERS = GridLauncherV3.buildLaunchers();

    public static void main(String[] args) throws Exception {
        new GridLauncherV3(args).launch();
    }

    public GridLauncherV3(String[] args) {
        this(System.out, args);
    }

    @VisibleForTesting
    public GridLauncherV3(PrintStream out, String[] args) {
        this.out = out;
        this.args = args;
    }

    public Optional<Stoppable> launch() {
        GridItemLauncher launcher = this.buildLauncher(this.args);
        if (launcher == null) {
            return Optional.empty();
        }
        if (launcher.getConfiguration().help) {
            launcher.printUsage(this.out);
            return Optional.empty();
        }
        if (launcher.getConfiguration().version) {
            this.out.println(String.format("Selenium server version: %s, revision: %s", buildInfo.getReleaseLabel(), buildInfo.getBuildRevision()));
            return Optional.empty();
        }
        GridLauncherV3.configureLogging(launcher.getConfiguration());
        log.info(String.format("Selenium build info: version: '%s', revision: '%s'", buildInfo.getReleaseLabel(), buildInfo.getBuildRevision()));
        try {
            return Optional.of(launcher.launch());
        }
        catch (Exception e) {
            launcher.printUsage(this.out);
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private GridItemLauncher buildLauncher(String[] args) {
        String role = "standalone";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-htmlSuite")) {
                Function<String[], GridItemLauncher> launcherSupplier = LAUNCHERS.get("corerunner");
                if (launcherSupplier == null) {
                    this.out.println(Joiner.on((String)"\n").join((Object)"Unable to find the HTML runner. This is normally because you have not downloaded", (Object)"or made available the 'selenium-leg-rc' jar on the CLASSPATH. Your test will", new Object[]{"not be run.", "Download the Selenium HTML Runner from http://www.seleniumhq.org/download/ and", "use that in place of the selenium-server-standalone.jar for the simplest way of", "running your HTML suite."}));
                    return null;
                }
                return launcherSupplier.apply(args);
            }
            if (args[i].startsWith("-role=")) {
                role = args[i].substring("-role=".length());
                continue;
            }
            if (!args[i].equals("-role")) continue;
            role = ++i < args.length ? args[i] : null;
        }
        GridRole gridRole = GridRole.get(role);
        if (gridRole == null || LAUNCHERS.get(gridRole.toString()) == null) {
            this.printInfoAboutRoles(role);
            return null;
        }
        return LAUNCHERS.get(gridRole.toString()).apply(args);
    }

    private void printInfoAboutRoles(String roleCommandLineArg) {
        if (roleCommandLineArg != null) {
            this.printWrappedLine("", "Error: the role '" + roleCommandLineArg + "' does not match a recognized server role: node/hub/standalone\n");
        } else {
            this.printWrappedLine("", "Error: -role option needs to be followed by the value that defines role of this component in the grid\n");
        }
        this.out.println("Selenium server can run in one of the following roles:\n  hub         as a hub of a Selenium grid\n  node        as a node of a Selenium grid\n  standalone  as a standalone server not being a part of a grid\n\nIf -role option is omitted the server runs standalone\n");
        this.printWrappedLine("", "To get help on the options available for a specific role run the server with -help option and the corresponding -role option value");
    }

    private void printWrappedLine(String prefix, String msg) {
        this.printWrappedLine(this.out, prefix, msg, true);
    }

    private void printWrappedLine(PrintStream output, String prefix, String msg, boolean first) {
        int defaultWrap;
        int wrap;
        output.print(prefix);
        if (!first) {
            output.print("  ");
        }
        if ((wrap = (defaultWrap = 70) - prefix.length()) > msg.length()) {
            output.println(msg);
            return;
        }
        String lineRaw = msg.substring(0, wrap);
        int spaceIndex = lineRaw.lastIndexOf(32);
        if (spaceIndex == -1) {
            spaceIndex = lineRaw.length();
        }
        String line = lineRaw.substring(0, spaceIndex);
        output.println(line);
        this.printWrappedLine(output, prefix, msg.substring(spaceIndex + 1), false);
    }

    private static void configureLogging(StandaloneConfiguration configuration) {
        String logFilename;
        Level logLevel;
        Level level = logLevel = configuration.debug != false ? Level.FINE : LoggingOptions.getDefaultLogLevel();
        if (logLevel == null) {
            logLevel = Level.INFO;
        }
        Logger.getLogger("").setLevel(logLevel);
        Logger.getLogger("org.openqa.jetty").setLevel(Level.WARNING);
        String string = logFilename = configuration.log != null ? configuration.log : LoggingOptions.getDefaultLogOutFile();
        if (logFilename != null) {
            for (Handler handler : Logger.getLogger("").getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                Logger.getLogger("").removeHandler(handler);
            }
            try {
                FileHandler logFile = new FileHandler(new File(logFilename).getAbsolutePath(), true);
                logFile.setFormatter(new TerseFormatter());
                logFile.setLevel(logLevel);
                Logger.getLogger("").addHandler(logFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            for (Handler handler : Logger.getLogger("").getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                handler.setLevel(logLevel);
                handler.setFormatter(new TerseFormatter());
            }
        }
    }

    private static Map<String, Function<String[], GridItemLauncher>> buildLaunchers() {
        ImmutableMap.Builder launchers = ImmutableMap.builder().put((Object)GridRole.NOT_GRID.toString(), args -> new GridItemLauncher((String[])args){
            StandaloneConfiguration configuration = new StandaloneConfiguration();
            final /* synthetic */ String[] val$args;
            {
                this.val$args = stringArray;
                JCommander.newBuilder().addObject((Object)this.configuration).build().parse(this.val$args);
            }

            @Override
            public StandaloneConfiguration getConfiguration() {
                return this.configuration;
            }

            @Override
            public Stoppable launch() throws Exception {
                log.info(String.format("Launching a standalone Selenium Server on port %s", this.configuration.port));
                SeleniumServer server = new SeleniumServer(this.configuration);
                HashMap<String, Class<? extends Servlet>> servlets = new HashMap<String, Class<? extends Servlet>>();
                servlets.put("/*", DisplayHelpServlet.class);
                server.setExtraServlets(servlets);
                server.boot();
                return server;
            }
        }).put((Object)GridRole.HUB.toString(), args -> new GridItemLauncher((String[])args){
            GridHubConfiguration configuration;
            final /* synthetic */ String[] val$args;
            {
                this.val$args = stringArray;
                GridHubConfiguration pending = new GridHubConfiguration();
                JCommander.newBuilder().addObject((Object)pending).build().parse(this.val$args);
                this.configuration = pending;
                if (pending.hubConfig != null) {
                    this.configuration = GridHubConfiguration.loadFromJSON(pending.hubConfig);
                    JCommander.newBuilder().addObject((Object)this.configuration).build().parse(this.val$args);
                }
            }

            @Override
            public StandaloneConfiguration getConfiguration() {
                return this.configuration;
            }

            @Override
            public Stoppable launch() throws Exception {
                log.info(String.format("Launching Selenium Grid hub on port %s", this.configuration.port));
                Hub hub = new Hub(this.configuration);
                hub.start();
                return hub;
            }
        }).put((Object)GridRole.NODE.toString(), args -> new GridItemLauncher((String[])args){
            GridNodeConfiguration configuration;
            final /* synthetic */ String[] val$args;
            {
                this.val$args = stringArray;
                GridNodeConfiguration pending = new GridNodeConfiguration();
                JCommander.newBuilder().addObject((Object)pending).build().parse(this.val$args);
                this.configuration = pending;
                if (pending.nodeConfigFile != null) {
                    this.configuration = GridNodeConfiguration.loadFromJSON(pending.nodeConfigFile);
                    JCommander.newBuilder().addObject((Object)this.configuration).build().parse(this.val$args);
                }
                if (this.configuration.port == null) {
                    this.configuration.port = 5555;
                }
            }

            @Override
            public StandaloneConfiguration getConfiguration() {
                return this.configuration;
            }

            @Override
            public Stoppable launch() throws Exception {
                log.info(String.format("Launching a Selenium Grid node on port %s", this.configuration.port));
                SelfRegisteringRemote remote = new SelfRegisteringRemote(this.configuration);
                SeleniumServer server = new SeleniumServer(remote.getConfiguration());
                remote.setRemoteServer(server);
                if (remote.startRemoteServer()) {
                    log.info("Selenium Grid node is up and ready to register to the hub");
                    remote.startRegistrationProcess();
                }
                return server;
            }
        });
        try {
            Class.forName(CORE_RUNNER_CLASS, false, GridLauncherV3.class.getClassLoader());
            launchers.put((Object)"corerunner", args -> new GridItemLauncher((String[])args){
                CoreRunnerConfiguration configuration = new CoreRunnerConfiguration();
                final /* synthetic */ String[] val$args;
                {
                    this.val$args = stringArray;
                    JCommander.newBuilder().addObject((Object)this.configuration).build().parse(this.val$args);
                }

                @Override
                public StandaloneConfiguration getConfiguration() {
                    return this.configuration;
                }

                @Override
                public Stoppable launch() throws Exception {
                    Class<?> coreRunnerClass = Class.forName(GridLauncherV3.CORE_RUNNER_CLASS);
                    Object coreRunner = coreRunnerClass.newInstance();
                    Method mainInt = coreRunnerClass.getMethod("mainInt", String[].class);
                    CoreRunnerConfiguration runnerConfig = this.configuration;
                    String[] args = new String[]{"-htmlSuite", runnerConfig.htmlSuite.get(0), runnerConfig.htmlSuite.get(1), runnerConfig.htmlSuite.get(2), runnerConfig.htmlSuite.get(3)};
                    mainInt.invoke(coreRunner, new Object[]{args});
                    return () -> {};
                }
            });
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return launchers.build();
    }

    private static interface GridItemLauncher {
        public StandaloneConfiguration getConfiguration();

        public Stoppable launch() throws Exception;

        default public void printUsage(PrintStream out) {
            StringBuilder sb = new StringBuilder();
            new JCommander((Object)this.getConfiguration()).usage(sb);
            out.print(sb);
        }
    }
}

