/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.beust.jcommander.JCommander;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.selenium.node.ChromeMutator;
import org.openqa.grid.selenium.node.FirefoxMutator;
import org.openqa.grid.shared.GridNodeServer;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DefaultDriverFactory;
import org.openqa.selenium.remote.server.DefaultDriverSessions;
import org.openqa.selenium.remote.server.DefaultPipeline;
import org.openqa.selenium.remote.server.DriverServlet;
import org.openqa.selenium.remote.server.NewSessionPipeline;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.WebDriverServlet;
import org.openqa.selenium.remote.server.handler.DeleteSession;
import org.openqa.selenium.remote.server.jmx.JMXHelper;
import org.openqa.selenium.remote.server.jmx.ManagedService;
import org.seleniumhq.jetty9.security.ConstraintMapping;
import org.seleniumhq.jetty9.security.ConstraintSecurityHandler;
import org.seleniumhq.jetty9.server.ConnectionFactory;
import org.seleniumhq.jetty9.server.Connector;
import org.seleniumhq.jetty9.server.Handler;
import org.seleniumhq.jetty9.server.HttpConfiguration;
import org.seleniumhq.jetty9.server.HttpConnectionFactory;
import org.seleniumhq.jetty9.server.Server;
import org.seleniumhq.jetty9.server.ServerConnector;
import org.seleniumhq.jetty9.servlet.ServletContextHandler;
import org.seleniumhq.jetty9.util.security.Constraint;
import org.seleniumhq.jetty9.util.thread.QueuedThreadPool;
import org.seleniumhq.jetty9.util.thread.ThreadPool;

@ManagedService(objectName="org.seleniumhq.server:type=SeleniumServer")
public class SeleniumServer
implements GridNodeServer {
    private static final Logger LOG = Logger.getLogger(SeleniumServer.class.getName());
    private Server server;
    private DefaultDriverSessions driverSessions;
    private StandaloneConfiguration configuration;
    private Map<String, Class<? extends Servlet>> extraServlets;
    private Thread shutDownHook;
    private final Object shutdownLock = new Object();
    private static final int MAX_SHUTDOWN_RETRIES = 8;

    public SeleniumServer(StandaloneConfiguration configuration) {
        this.configuration = configuration;
        new JMXHelper().register(this);
    }

    @Override
    public int getRealPort() {
        if (this.server.isStarted()) {
            ServerConnector socket = (ServerConnector)this.server.getConnectors()[0];
            return socket.getPort();
        }
        return this.configuration.port;
    }

    private void addRcSupport(ServletContextHandler handler) {
        try {
            Class<Servlet> rcServlet = Class.forName("com.thoughtworks.selenium.webdriven.WebDriverBackedSeleniumServlet", false, this.getClass().getClassLoader()).asSubclass(Servlet.class);
            handler.addServlet(rcServlet, "/selenium-server/driver/");
            LOG.info("Bound legacy RC support");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void addExtraServlets(ServletContextHandler handler) {
        if (this.extraServlets != null && this.extraServlets.size() > 0) {
            for (String path : this.extraServlets.keySet()) {
                handler.addServlet(this.extraServlets.get(path), path);
            }
        }
    }

    @Override
    public void setConfiguration(StandaloneConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setExtraServlets(Map<String, Class<? extends Servlet>> extraServlets) {
        this.extraServlets = extraServlets;
    }

    @Override
    public void boot() {
        long inactiveSessionTimeoutSeconds;
        this.server = this.configuration.jettyMaxThreads != null && this.configuration.jettyMaxThreads > 0 ? new Server((ThreadPool)new QueuedThreadPool(this.configuration.jettyMaxThreads.intValue())) : new Server();
        ServletContextHandler handler = new ServletContextHandler(2);
        if (this.configuration.browserTimeout != null && this.configuration.browserTimeout >= 0) {
            handler.setInitParameter("webdriver.server.browser.timeout", String.valueOf(this.configuration.browserTimeout));
        }
        long l = inactiveSessionTimeoutSeconds = this.configuration.timeout == null ? 9223372036854775L : (long)this.configuration.timeout.intValue();
        if (this.configuration.timeout != null && this.configuration.timeout >= 0) {
            handler.setInitParameter("webdriver.server.session.timeout", String.valueOf(this.configuration.timeout));
        }
        this.driverSessions = new DefaultDriverSessions(new DefaultDriverFactory(Platform.getCurrent()), TimeUnit.SECONDS.toMillis(inactiveSessionTimeoutSeconds));
        handler.setAttribute(DriverServlet.SESSIONS_KEY, (Object)this.driverSessions);
        NewSessionPipeline pipeline = this.createPipeline(this.configuration);
        handler.setAttribute(WebDriverServlet.NEW_SESSION_PIPELINE_KEY, (Object)pipeline);
        handler.setContextPath("/");
        if (this.configuration.enablePassThrough) {
            LOG.info("Using the passthrough mode handler");
            handler.addServlet(WebDriverServlet.class, "/wd/hub/*");
            handler.addServlet(WebDriverServlet.class, "/webdriver/*");
        } else {
            handler.addServlet(DriverServlet.class, "/wd/hub/*");
            handler.addServlet(DriverServlet.class, "/webdriver/*");
        }
        handler.setInitParameter("webdriver.server.consoleservlet.path", "/wd/hub");
        handler.setInitParameter("webdriver.server.displayhelpservlet.type", this.configuration.role);
        this.addRcSupport(handler);
        this.addExtraServlets(handler);
        Constraint constraint = new Constraint();
        constraint.setName("Disable TRACE");
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setMethod("TRACE");
        mapping.setPathSpec("/");
        ConstraintSecurityHandler securityHandler = (ConstraintSecurityHandler)handler.getSecurityHandler();
        securityHandler.addConstraintMapping(mapping);
        this.server.setHandler((Handler)handler);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        ServerConnector http = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        if (this.configuration.port == null) {
            this.configuration.port = 4444;
        }
        http.setPort(this.configuration.port.intValue());
        http.setIdleTimeout(500000L);
        this.server.setConnectors(new Connector[]{http});
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private NewSessionPipeline createPipeline(StandaloneConfiguration configuration) {
        NewSessionPipeline.Builder builder = DefaultPipeline.createPipelineWithDefaultFallbacks();
        if (configuration instanceof GridNodeConfiguration) {
            ((GridNodeConfiguration)configuration).capabilities.forEach(caps -> {
                builder.addCapabilitiesMutator(new ChromeMutator((Capabilities)caps));
                builder.addCapabilitiesMutator(new FirefoxMutator((Capabilities)caps));
            });
        }
        return builder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        int numTries = 0;
        Exception shutDownException = null;
        try {
            if (this.shutDownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        while (numTries <= 8) {
            ++numTries;
            try {
                Object object = this.shutdownLock;
                synchronized (object) {
                    this.server.stop();
                    break;
                }
            }
            catch (Exception ex) {
                shutDownException = ex;
            }
        }
        this.stopAllBrowsers();
        if (numTries > 8 && null != shutDownException) {
            throw new RuntimeException(shutDownException);
        }
    }

    private void stopAllBrowsers() {
        for (SessionId sessionId : this.driverSessions.getSessions()) {
            Session session = this.driverSessions.get(sessionId);
            DeleteSession deleteSession = new DeleteSession(session);
            try {
                deleteSession.call();
                this.driverSessions.deleteSession(sessionId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] argv) {
        StandaloneConfiguration configuration = new StandaloneConfiguration();
        JCommander jCommander = new JCommander((Object)configuration, argv);
        jCommander.setProgramName("selenium-3-server");
        if (configuration.help) {
            StringBuilder message = new StringBuilder();
            jCommander.usage(message);
            System.err.println(message.toString());
            return;
        }
        SeleniumServer server = new SeleniumServer(configuration);
        server.boot();
    }

    public static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        StandaloneConfiguration args = new StandaloneConfiguration();
        JCommander jCommander = new JCommander((Object)args);
        jCommander.usage();
    }
}

