/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.web.servlet.handler.RequestHandler;
import org.openqa.selenium.remote.DesiredCapabilities;

@ThreadSafe
public class NewSessionRequestQueue {
    private static final Logger log = Logger.getLogger(NewSessionRequestQueue.class.getName());
    private final List<RequestHandler> newSessionRequests = new ArrayList<RequestHandler>();

    public synchronized void add(RequestHandler request) {
        this.newSessionRequests.add(request);
    }

    public synchronized void processQueue(Predicate<RequestHandler> handlerConsumer, Prioritizer prioritizer) {
        ArrayList<RequestHandler> copy = new ArrayList<RequestHandler>(this.newSessionRequests);
        if (prioritizer != null) {
            copy.sort((a, b) -> prioritizer.compareTo(a.getRequest().getDesiredCapabilities(), b.getRequest().getDesiredCapabilities()));
        }
        copy.stream().filter(handlerConsumer).forEach(requestHandler -> {
            if (!this.removeNewSessionRequest((RequestHandler)requestHandler)) {
                log.severe("Bug removing request " + requestHandler);
            }
        });
    }

    public synchronized void clearNewSessionRequests() {
        this.newSessionRequests.clear();
    }

    public synchronized boolean removeNewSessionRequest(RequestHandler request) {
        return this.newSessionRequests.remove(request);
    }

    public synchronized Iterable<DesiredCapabilities> getDesiredCapabilities() {
        return this.newSessionRequests.stream().map(req -> new DesiredCapabilities(req.getRequest().getDesiredCapabilities())).collect(Collectors.toList());
    }

    public synchronized int getNewSessionRequestCount() {
        return this.newSessionRequests.size();
    }

    public synchronized void stop() {
        this.newSessionRequests.forEach(RequestHandler::stop);
    }
}

