/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import java.net.URL;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.servlet.Servlet;
import org.openqa.selenium.grid.component.HasLifecycle;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.UrlTemplate;
import org.openqa.selenium.injector.Injector;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

public interface Server<T extends Server>
extends HasLifecycle<T> {
    public boolean isStarted();

    @Deprecated
    public void addServlet(Class<? extends Servlet> var1, String var2);

    @Deprecated
    public void addServlet(Servlet var1, String var2);

    public void addHandler(Predicate<HttpRequest> var1, BiFunction<Injector, HttpRequest, CommandHandler> var2);

    public URL getUrl();

    default public void addHandler(HttpMethod method, String urlTemplate, BiFunction<Injector, HttpRequest, CommandHandler> handler) {
        Objects.requireNonNull(method, "Method must be set");
        UrlTemplate template = new UrlTemplate(urlTemplate);
        this.addHandler(req -> method == req.getMethod() && template.match(req.getUri()) != null, (inj, req) -> {
            UrlTemplate.Match match = template.match(req.getUri());
            if (match != null && match.getParameters().get("sessionId") != null) {
                inj = Injector.builder().parent((Injector)inj).register(new SessionId(match.getParameters().get("sessionId"))).build();
            }
            return (CommandHandler)handler.apply((Injector)inj, (HttpRequest)req);
        });
    }

    public static Predicate<HttpRequest> delete(String template) {
        UrlTemplate urlTemplate = new UrlTemplate(template);
        return req -> HttpMethod.DELETE == req.getMethod() && urlTemplate.match(req.getUri()) != null;
    }

    public static Predicate<HttpRequest> get(String template) {
        UrlTemplate urlTemplate = new UrlTemplate(template);
        return req -> HttpMethod.GET == req.getMethod() && urlTemplate.match(req.getUri()) != null;
    }

    public static Predicate<HttpRequest> post(String template) {
        UrlTemplate urlTemplate = new UrlTemplate(template);
        return req -> HttpMethod.POST == req.getMethod() && urlTemplate.match(req.getUri()) != null;
    }
}

