/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;

public class TestSessionStatusServlet
extends RegistryBasedServlet {
    private final Json json = new Json();

    public TestSessionStatusServlet() {
        super(null);
    }

    public TestSessionStatusServlet(GridRegistry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        try (PrintWriter writer = response.getWriter();
             JsonOutput out = this.json.newOutput((Appendable)writer);){
            out.write(this.getResponse(request), Json.MAP_TYPE);
        }
        catch (JsonException e) {
            throw new GridException(e.getMessage());
        }
    }

    private Map<String, Object> getResponse(HttpServletRequest request) throws IOException {
        String session;
        Map requestJSON = null;
        if (request.getInputStream() != null) {
            try (BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
                 JsonInput jin = this.json.newInput((Reader)rd);){
                requestJSON = (Map)jin.read(Json.MAP_TYPE);
            }
        }
        TreeMap<String, Object> res = new TreeMap<String, Object>();
        res.put("success", false);
        if (requestJSON == null) {
            session = request.getParameter("session");
        } else {
            if (!requestJSON.containsKey("session")) {
                res.put("msg", "you need to specify at least a session or internalKey when call the test slot status service.");
                return res;
            }
            session = String.valueOf(requestJSON.get("session"));
        }
        TestSession testSession = this.getRegistry().getSession(ExternalSessionKey.fromString(session));
        if (testSession == null) {
            res.put("msg", "Cannot find test slot running session " + session + " in the registry.");
            return res;
        }
        res.put("msg", "slot found !");
        res.remove("success");
        res.put("success", true);
        res.put("session", testSession.getExternalKey().getKey());
        res.put("internalKey", testSession.getInternalKey());
        res.put("inactivityTime", testSession.getInactivityTime());
        RemoteProxy p = testSession.getSlot().getProxy();
        res.put("proxyId", p.getId());
        return res;
    }
}

