/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.collect.ImmutableSortedMap;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;

public class HubStatusServlet
extends RegistryBasedServlet {
    private final Json json = new Json();

    public HubStatusServlet() {
        super(null);
    }

    public HubStatusServlet(GridRegistry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.process(req, resp);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        try (PrintWriter writer = response.getWriter();
             JsonOutput out = this.json.newOutput((Appendable)writer);){
            Map<String, Object> res = this.getResponse(request);
            out.write(res, Json.MAP_TYPE);
        }
    }

    private Map<String, Object> getResponse(HttpServletRequest request) {
        TreeMap<String, Object> res = new TreeMap<String, Object>();
        res.put("success", true);
        try {
            if (request.getInputStream() != null) {
                Map<String, Object> requestJSON = this.getRequestJSON(request);
                List<String> keysToReturn = null;
                if (request.getParameter("configuration") != null && !"".equals(request.getParameter("configuration"))) {
                    keysToReturn = Arrays.asList(request.getParameter("configuration").split(","));
                } else if (requestJSON != null && requestJSON.containsKey("configuration")) {
                    keysToReturn = (List<String>)requestJSON.get("configuration");
                }
                GridRegistry registry = this.getRegistry();
                JsonElement config = registry.getConfiguration().toJson();
                for (Map.Entry entry : config.getAsJsonObject().entrySet()) {
                    if (keysToReturn != null && !keysToReturn.isEmpty() && !keysToReturn.contains(entry.getKey())) continue;
                    res.put((String)entry.getKey(), entry.getValue());
                }
                if (keysToReturn == null || keysToReturn.isEmpty() || keysToReturn.contains("newSessionRequestCount")) {
                    res.put("newSessionRequestCount", registry.getNewSessionRequestCount());
                }
                if (keysToReturn == null || keysToReturn.isEmpty() || keysToReturn.contains("slotCounts")) {
                    res.put("slotCounts", this.getSlotCounts());
                }
            }
        }
        catch (Exception e) {
            res.remove("success");
            res.put("success", false);
            res.put("msg", e.getMessage());
        }
        return res;
    }

    private Map<String, Object> getSlotCounts() {
        int totalSlots = 0;
        int usedSlots = 0;
        for (RemoteProxy proxy : this.getRegistry().getAllProxies()) {
            totalSlots += Math.min(proxy.getMaxNumberOfConcurrentTestSessions(), proxy.getTestSlots().size());
            usedSlots += proxy.getTotalUsed();
        }
        return ImmutableSortedMap.of((Comparable)((Object)"free"), (Object)(totalSlots - usedSlots), (Comparable)((Object)"total"), (Object)totalSlots);
    }

    /*
     * Exception decompiling
     */
    private Map<String, Object> getRequestJSON(HttpServletRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

