/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.common.exception.CapabilityNotPresentOnTheGridException;
import org.openqa.grid.internal.GridException;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.web.servlet.handler.RequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ProxySet
implements Iterable<RemoteProxy> {
    private final Set<RemoteProxy> proxies = new CopyOnWriteArraySet<RemoteProxy>();
    private static final Logger log = Logger.getLogger(ProxySet.class.getName());
    private volatile boolean throwOnCapabilityNotPresent = true;

    public ProxySet(boolean throwOnCapabilityNotPresent) {
        this.throwOnCapabilityNotPresent = throwOnCapabilityNotPresent;
    }

    public void teardown() {
        for (RemoteProxy proxy : this.proxies) {
            proxy.teardown();
        }
    }

    public boolean hasCapability(Map<String, Object> requestedCapability) {
        for (RemoteProxy proxy : this.proxies) {
            if (!proxy.hasCapability(requestedCapability)) continue;
            return true;
        }
        return false;
    }

    private void forceRelease(RemoteProxy proxy) {
        for (RemoteProxy p : this.proxies) {
            if (!p.equals(proxy)) continue;
            this.proxies.remove(p);
            for (TestSlot slot : p.getTestSlots()) {
                slot.forceRelease();
            }
        }
    }

    public void removeIfPresent(RemoteProxy proxy) {
        if (this.proxies.contains(proxy)) {
            log.warning(String.format("Proxy '%s' was previously registered.  Cleaning up any stale test sessions.", proxy));
            this.forceRelease(proxy);
        }
    }

    public void add(RemoteProxy proxy) {
        this.proxies.add(proxy);
    }

    public boolean contains(RemoteProxy o) {
        return this.proxies.contains(o);
    }

    public List<RemoteProxy> getBusyProxies() {
        ArrayList<RemoteProxy> res = new ArrayList<RemoteProxy>();
        for (RemoteProxy proxy : this.proxies) {
            if (!proxy.isBusy()) continue;
            res.add(proxy);
        }
        return res;
    }

    public RemoteProxy getProxyById(String id) {
        if (id == null) {
            return null;
        }
        for (RemoteProxy p : this.proxies) {
            if (!id.equals(p.getId())) continue;
            return p;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.proxies.isEmpty();
    }

    public List<RemoteProxy> getSorted() {
        ArrayList<RemoteProxy> sorted = new ArrayList<RemoteProxy>(this.proxies);
        Collections.sort(sorted);
        return sorted;
    }

    @Override
    public Iterator<RemoteProxy> iterator() {
        return this.proxies.iterator();
    }

    public int size() {
        return this.proxies.size();
    }

    public void verifyNewSessionRequest(RequestHandler request) {
        if (this.proxies.isEmpty()) {
            if (this.throwOnCapabilityNotPresent) {
                throw new GridException("Empty pool of VM for setup " + request.getDesiredCapabilities());
            }
            log.warning("Empty pool of nodes.");
        }
        if (!this.hasCapability(request.getDesiredCapabilities())) {
            if (this.throwOnCapabilityNotPresent) {
                throw new CapabilityNotPresentOnTheGridException(request.getDesiredCapabilities());
            }
            log.warning("grid doesn't contain " + request.getDesiredCapabilities() + " at the moment.");
        }
    }

    public void setThrowOnCapabilityNotPresent(boolean throwOnCapabilityNotPresent) {
        this.throwOnCapabilityNotPresent = throwOnCapabilityNotPresent;
    }
}

