/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import com.google.common.collect.ImmutableList;
import java.util.List;

public enum GridRole {
    NOT_GRID,
    HUB,
    NODE;

    private static List<String> rcAliases;
    private static List<String> wdAliases;
    private static List<String> nodeAliases;

    public static GridRole find(String[] args) {
        if (args == null) {
            return NOT_GRID;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!"-role".equals(args[i])) continue;
            if (i == args.length - 1) {
                return null;
            }
            String role = args[i + 1].toLowerCase();
            if (nodeAliases.contains(role)) {
                return NODE;
            }
            if ("hub".equals(role)) {
                return HUB;
            }
            if ("standalone".equals(role)) {
                return NOT_GRID;
            }
            return null;
        }
        return NOT_GRID;
    }

    public static boolean isRC(String nodeType) {
        return rcAliases.contains(nodeType);
    }

    public static boolean isWebDriver(String nodeType) {
        return wdAliases.contains(nodeType);
    }

    static {
        rcAliases = new ImmutableList.Builder().add((Object)"rc").add((Object)"remotecontrol").add((Object)"remote-control").build();
        wdAliases = new ImmutableList.Builder().add((Object)"wd").add((Object)"webdriver").build();
        nodeAliases = new ImmutableList.Builder().add((Object)"node").addAll(rcAliases).addAll(wdAliases).build();
    }
}

