/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium.proxy;

import java.util.Map;
import java.util.logging.Logger;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.listeners.TestSessionListener;
import org.openqa.grid.selenium.proxy.WebRemoteProxy;

public class WebDriverRemoteProxy
extends WebRemoteProxy
implements TestSessionListener {
    private static final Logger log = Logger.getLogger(WebDriverRemoteProxy.class.getName());

    public WebDriverRemoteProxy(RegistrationRequest request, Registry registry) {
        super(request, registry);
    }

    public void beforeRelease(TestSession session) {
        if (session.getExternalKey() == null) {
            throw new IllegalStateException("No internal key yet. Did the app start properlty?");
        }
        System.err.println("timing out " + session);
        boolean ok = session.sendDeleteSessionRequest();
        if (!ok) {
            log.warning("Error releasing the resources on timeout for session " + session);
        }
    }

    public void beforeSession(TestSession session) {
        Map<String, Object> cap = session.getRequestedCapabilities();
        if ("firefox".equals(cap.get("browserName")) && session.getSlot().getCapabilities().get("firefox_binary") != null && cap.get("firefox_binary") == null) {
            session.getRequestedCapabilities().put("firefox_binary", session.getSlot().getCapabilities().get("firefox_binary"));
        }
    }

    public void afterSession(TestSession session) {
    }
}

