/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DefaultDriverFactory;
import org.openqa.selenium.remote.server.DefaultSession;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.DriverProvider;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.Session;

public class DefaultDriverSessions
implements DriverSessions {
    private static final Logger log = Logger.getLogger(DefaultDriverSessions.class.getName());
    private final DriverFactory factory;
    private final Map<SessionId, Session> sessionIdToDriver = new ConcurrentHashMap<SessionId, Session>();
    private static Map<Capabilities, String> defaultDrivers = new HashMap<Capabilities, String>(){
        {
            this.put(DesiredCapabilities.chrome(), "org.openqa.selenium.chrome.ChromeDriver");
            this.put(DesiredCapabilities.firefox(), "org.openqa.selenium.firefox.FirefoxDriver");
            this.put(DesiredCapabilities.htmlUnit(), "org.openqa.selenium.htmlunit.HtmlUnitDriver");
            this.put(DesiredCapabilities.internetExplorer(), "org.openqa.selenium.ie.InternetExplorerDriver");
            this.put(DesiredCapabilities.opera(), "com.opera.core.systems.OperaDriver");
            this.put(DesiredCapabilities.safari(), "org.openqa.selenium.safari.SafariDriver");
            this.put(DesiredCapabilities.phantomjs(), "org.openqa.selenium.phantomjs.PhantomJSDriver");
        }
    };

    public DefaultDriverSessions() {
        this(Platform.getCurrent(), new DefaultDriverFactory());
    }

    public DefaultDriverSessions(DriverFactory factory, Map<Capabilities, Class<? extends WebDriver>> drivers) {
        this.factory = factory;
        for (Map.Entry<Capabilities, Class<? extends WebDriver>> entry : drivers.entrySet()) {
            this.registerDriver(entry.getKey(), entry.getValue());
        }
    }

    protected DefaultDriverSessions(Platform runningOn, DriverFactory factory) {
        this.factory = factory;
        this.registerDefaults(runningOn);
        this.registerDriverProviders(runningOn);
    }

    private void registerDefaults(Platform current) {
        for (Map.Entry<Capabilities, String> entry : defaultDrivers.entrySet()) {
            Capabilities caps = entry.getKey();
            if (caps.getPlatform() == null || caps.getPlatform() == Platform.ANY || current.is(caps.getPlatform())) {
                this.registerDriver(caps, entry.getValue());
                continue;
            }
            log.info("Default driver " + entry.getValue() + " registration is skipped: registration capabilities " + caps.toString() + " does not match with current platform: " + current.toString());
        }
    }

    private void registerDriverProviders(Platform current) {
        for (DriverProvider provider : ServiceLoader.load(DriverProvider.class)) {
            Capabilities caps = provider.getProvidedCapabilities();
            if (caps.getPlatform() == null || caps.getPlatform() == Platform.ANY || current.is(caps.getPlatform())) {
                this.factory.registerDriverProvider(caps, provider);
                continue;
            }
            log.info("Driver provider " + provider + " registration is skipped: registration capabilities " + caps.toString() + " does not match with current platform: " + current.toString());
        }
    }

    private void registerDriver(Capabilities caps, String className) {
        try {
            this.registerDriver(caps, Class.forName(className).asSubclass(WebDriver.class));
        }
        catch (ClassNotFoundException e) {
            log.log(Level.INFO, "Unable to register driver with className " + className + " due to ClassNotFoundException");
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.WARNING, "Unable to register driver with className " + className + " due to NoClassDefFoundError");
        }
    }

    @Override
    public SessionId newSession(Capabilities desiredCapabilities) throws Exception {
        SessionId sessionId = new SessionId(UUID.randomUUID().toString());
        Session session = DefaultSession.createSession(this.factory, sessionId, desiredCapabilities);
        this.sessionIdToDriver.put(sessionId, session);
        return sessionId;
    }

    @Override
    public Session get(SessionId sessionId) {
        return this.sessionIdToDriver.get(sessionId);
    }

    @Override
    public void deleteSession(SessionId sessionId) {
        Session removedSession = this.sessionIdToDriver.remove(sessionId);
        if (removedSession != null) {
            removedSession.close();
        }
    }

    @Override
    public void registerDriver(Capabilities capabilities, Class<? extends WebDriver> implementation) {
        this.factory.registerDriver(capabilities, implementation);
    }

    @Override
    public Set<SessionId> getSessions() {
        return Collections.unmodifiableSet(this.sessionIdToDriver.keySet());
    }
}

