/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.SessionTerminationReason;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.internal.listeners.TimeoutListener;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.grid.internal.utils.DefaultHtmlRenderer;
import org.openqa.grid.internal.utils.HtmlRenderer;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.internal.HttpClientFactory;

public class BaseRemoteProxy
implements RemoteProxy {
    private final RegistrationRequest request;
    private final int cleanUpCycle;
    private final int timeOutMs;
    private static final Logger log = Logger.getLogger(BaseRemoteProxy.class.getName());
    protected volatile URL remoteHost;
    private final Map<String, Object> config;
    private final List<TestSlot> testSlots;
    private final int maxConcurrentSession;
    private final Registry registry;
    private final String id;
    private volatile boolean stop = false;
    private CleanUpThread cleanUpThread;
    private final int statusCheckTimeout;
    private final HtmlRenderer renderer = new DefaultHtmlRenderer(this);

    @Override
    public List<TestSlot> getTestSlots() {
        return this.testSlots;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public CapabilityMatcher getCapabilityHelper() {
        return this.registry.getCapabilityMatcher();
    }

    public BaseRemoteProxy(RegistrationRequest request, Registry registry) {
        this.request = request;
        this.registry = registry;
        this.config = this.mergeConfig(registry.getConfiguration().getAllParams(), request.getConfiguration());
        String url = (String)this.config.get("remoteHost");
        String id = (String)this.config.get("id");
        if (url == null && id == null) {
            throw new GridException("The registration request needs to specify either the remote host, or a valid id.");
        }
        if (url != null) {
            try {
                this.remoteHost = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new GridException("Not a correct url to register a remote : " + url);
            }
        }
        this.id = id != null ? id : this.remoteHost.toExternalForm();
        this.maxConcurrentSession = this.getConfigInteger("maxSession");
        this.cleanUpCycle = this.getConfigInteger("cleanUpCycle");
        this.timeOutMs = this.getConfigInteger("timeout");
        Object tm = this.config.get("nodeStatusCheckTimeout");
        if (tm == null) {
            tm = new Integer(0);
        }
        this.statusCheckTimeout = (Integer)tm;
        List<DesiredCapabilities> capabilities = request.getCapabilities();
        ArrayList<TestSlot> slots = new ArrayList<TestSlot>();
        for (DesiredCapabilities capability : capabilities) {
            Object maxInstance = capability.getCapability("maxInstances");
            SeleniumProtocol protocol = this.getProtocol(capability);
            String path = this.getPath(capability);
            if (maxInstance == null) {
                log.warning("Max instance not specified. Using default = 1 instance");
                maxInstance = "1";
            }
            int value = Integer.parseInt(maxInstance.toString());
            for (int i = 0; i < value; ++i) {
                HashMap<String, Object> c = new HashMap<String, Object>();
                for (String k : capability.asMap().keySet()) {
                    c.put(k, capability.getCapability(k));
                }
                slots.add(new TestSlot(this, protocol, path, c));
            }
        }
        this.testSlots = Collections.unmodifiableList(slots);
    }

    private Integer getConfigInteger(String key) {
        Object o = this.config.get(key);
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        return (Integer)o;
    }

    private SeleniumProtocol getProtocol(DesiredCapabilities capability) {
        SeleniumProtocol protocol;
        String type = (String)capability.getCapability("seleniumProtocol");
        if (type == null) {
            protocol = SeleniumProtocol.WebDriver;
        } else {
            try {
                protocol = SeleniumProtocol.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                throw new GridException(type + " isn't a valid protocol type for grid. See SeleniumProtocol enum.", e);
            }
        }
        return protocol;
    }

    private String getPath(DesiredCapabilities capability) {
        String type = (String)capability.getCapability("path");
        if (type == null) {
            switch (this.getProtocol(capability)) {
                case Selenium: {
                    return "/selenium-server/driver";
                }
                case WebDriver: {
                    return "/wd/hub";
                }
            }
            throw new GridException("Protocol not supported.");
        }
        return type;
    }

    @Override
    public void setupTimeoutListener() {
        this.cleanUpThread = null;
        if (this instanceof TimeoutListener && this.cleanUpCycle > 0 && this.timeOutMs > 0) {
            log.fine("starting cleanup thread");
            this.cleanUpThread = new CleanUpThread(this);
            new Thread((Runnable)this.cleanUpThread, "RemoteProxy CleanUpThread for " + this.getId()).start();
        }
    }

    private Map<String, Object> mergeConfig(Map<String, Object> configuration1, Map<String, Object> configuration2) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.putAll(configuration1);
        for (String key : configuration2.keySet()) {
            res.put(key, configuration2.get(key));
        }
        return res;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            throw new RuntimeException("Bug. Trying to use the id on a proxy but it hasn't been set.");
        }
        return this.id;
    }

    @Override
    public void teardown() {
        this.stop = true;
    }

    public void forceSlotCleanerRun() {
        this.cleanUpThread.cleanUpAllSlots();
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public RegistrationRequest getOriginalRegistrationRequest() {
        return this.request;
    }

    @Override
    public int getMaxNumberOfConcurrentTestSessions() {
        return this.maxConcurrentSession;
    }

    @Override
    public URL getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public TestSession getNewSession(Map<String, Object> requestedCapability) {
        log.info("Trying to create a new session on node " + this);
        if (!this.hasCapability(requestedCapability)) {
            log.info("Node " + this + " has no matching capability");
            return null;
        }
        if (this.getTotalUsed() >= this.maxConcurrentSession) {
            log.info("Node " + this + " has no free slots");
            return null;
        }
        for (TestSlot testslot : this.testSlots) {
            TestSession session = testslot.getNewSession(requestedCapability);
            if (session == null) continue;
            return session;
        }
        return null;
    }

    @Override
    public int getTotalUsed() {
        int totalUsed = 0;
        for (TestSlot slot : this.testSlots) {
            if (slot.getSession() == null) continue;
            ++totalUsed;
        }
        return totalUsed;
    }

    @Override
    public boolean hasCapability(Map<String, Object> requestedCapability) {
        for (TestSlot slot : this.testSlots) {
            if (!slot.matches(requestedCapability)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        return this.getTotalUsed() != 0;
    }

    public static <T extends RemoteProxy> T getNewInstance(RegistrationRequest request, Registry registry) {
        try {
            String proxyClass = request.getRemoteProxyClass();
            if (proxyClass == null) {
                log.fine("No proxy class. Using default");
                proxyClass = BaseRemoteProxy.class.getCanonicalName();
            }
            Class<?> clazz = Class.forName(proxyClass);
            log.fine("Using class " + clazz.getName());
            Object[] args = new Object[]{request, registry};
            Class[] argsClass = new Class[]{RegistrationRequest.class, Registry.class};
            Constructor<?> c = clazz.getConstructor(argsClass);
            Object proxy = c.newInstance(args);
            if (proxy instanceof RemoteProxy) {
                ((RemoteProxy)proxy).setupTimeoutListener();
                return (T)((RemoteProxy)proxy);
            }
            throw new InvalidParameterException("Error: " + proxy.getClass() + " isn't a remote proxy");
        }
        catch (InvocationTargetException e) {
            log.log(Level.SEVERE, e.getTargetException().getMessage(), e.getTargetException());
            throw new InvalidParameterException("Error: " + e.getTargetException().getMessage());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new InvalidParameterException("Error: " + e.getMessage());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteProxy other = (RemoteProxy)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    public int compareTo(RemoteProxy o) {
        if (o == null) {
            return -1;
        }
        return (int)(this.getResourceUsageInPercent() - o.getResourceUsageInPercent());
    }

    public String toString() {
        return "host :" + this.getRemoteHost() + (this.timeOutMs != -1 ? " time out : " + this.timeOutMs : "");
    }

    @Override
    public HtmlRenderer getHtmlRender() {
        return this.renderer;
    }

    @Override
    public int getTimeOut() {
        return this.timeOutMs;
    }

    @Override
    public HttpClientFactory getHttpClientFactory() {
        return this.getRegistry().getHttpClientFactory();
    }

    @Override
    public JSONObject getStatus() throws GridException {
        String url = this.getRemoteHost().toExternalForm() + "/wd/hub/status";
        BasicHttpRequest r = new BasicHttpRequest("GET", url);
        HttpClient client = this.getHttpClientFactory().getGridHttpClient(this.statusCheckTimeout, this.statusCheckTimeout);
        HttpHost host = new HttpHost(this.getRemoteHost().getHost(), this.getRemoteHost().getPort());
        String existingName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("Probing status of " + url);
            HttpResponse response = client.execute(host, (HttpRequest)r);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                JSONObject status = new JSONObject();
                try {
                    status = this.extractObject(response);
                }
                catch (Exception e) {
                    // empty catch block
                }
                EntityUtils.consume((HttpEntity)response.getEntity());
                JSONObject jSONObject = status;
                return jSONObject;
            }
            if (code == 404) {
                JSONObject status = new JSONObject();
                EntityUtils.consume((HttpEntity)response.getEntity());
                JSONObject jSONObject = status;
                return jSONObject;
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
                throw new GridException("server response code : " + code);
            }
            catch (Exception e) {
                throw new GridException(e.getMessage(), e);
            }
        }
        finally {
            Thread.currentThread().setName(existingName);
        }
    }

    private JSONObject extractObject(HttpResponse resp) throws IOException, JSONException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));
        StringBuilder s = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            s.append(line);
        }
        rd.close();
        return new JSONObject(s.toString());
    }

    @Override
    public float getResourceUsageInPercent() {
        return 100.0f * (float)this.getTotalUsed() / (float)this.getMaxNumberOfConcurrentTestSessions();
    }

    class CleanUpThread
    implements Runnable {
        private BaseRemoteProxy proxy;

        public CleanUpThread(BaseRemoteProxy proxy) {
            this.proxy = proxy;
        }

        @Override
        public void run() {
            log.fine("cleanup thread starting...");
            while (!this.proxy.stop) {
                try {
                    Thread.sleep(BaseRemoteProxy.this.cleanUpCycle);
                }
                catch (InterruptedException e) {
                    log.severe("clean up thread died. " + e.getMessage());
                }
                this.cleanUpAllSlots();
            }
        }

        void cleanUpAllSlots() {
            for (TestSlot slot : BaseRemoteProxy.this.testSlots) {
                try {
                    this.cleanUpSlot(slot);
                }
                catch (Throwable t) {
                    log.warning("Error executing the timeout when cleaning up slot " + slot + t.getMessage());
                }
            }
        }

        private void cleanUpSlot(TestSlot slot) {
            TestSession session = slot.getSession();
            if (session != null) {
                boolean hasTimedOut;
                long inactivity = session.getInactivityTime();
                boolean bl = hasTimedOut = inactivity > (long)BaseRemoteProxy.this.timeOutMs;
                if (hasTimedOut && !session.isForwardingRequest()) {
                    log.logp(Level.WARNING, "SessionCleanup", null, "session " + session + " has TIMED OUT due to client inactivity and will be released.");
                    ((TimeoutListener)((Object)this.proxy)).beforeRelease(session);
                    BaseRemoteProxy.this.registry.terminate(session, SessionTerminationReason.TIMEOUT);
                }
                if (session.isOrphaned()) {
                    log.logp(Level.WARNING, "SessionCleanup", null, "session " + session + " has been ORPHANED and will be released");
                    ((TimeoutListener)((Object)this.proxy)).beforeRelease(session);
                    BaseRemoteProxy.this.registry.terminate(session, SessionTerminationReason.ORPHAN);
                }
            }
        }
    }
}

