/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.openqa.selenium.server.cli.RemoteControlLauncher;

public class GridDocHelper {
    private static Properties gridProperties = GridDocHelper.load("org/openqa/grid/common/defaults/GridParameters.properties");

    public static void printHelp(String msg) {
        GridDocHelper.printHelpInConsole(msg, true);
    }

    public static void printHelp(String msg, boolean error) {
        GridDocHelper.printHelpInConsole(msg, error);
    }

    public static String getGridParam(String param) {
        if (param == null) {
            return "";
        }
        String s = (String)gridProperties.get(param);
        if (s == null) {
            return "No help specified for " + param;
        }
        return s;
    }

    private static void printHelpInConsole(String msg, boolean error) {
        String indent = "  ";
        String indent2x = indent + indent;
        if (msg != null) {
            if (error) {
                System.out.println("Error building the config :" + msg);
            } else {
                System.out.println(msg);
            }
        }
        System.out.println("Usage :");
        for (Object key : gridProperties.keySet()) {
            System.out.println(indent + "-" + key + ":\t");
            RemoteControlLauncher.printWrappedLine(System.out, indent2x, GridDocHelper.getGridParam(key.toString()), true);
            System.out.println("");
        }
    }

    private static Properties load(String resource) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        Properties p = new Properties();
        if (in != null) {
            try {
                p.load(in);
                return p;
            }
            catch (IOException e) {
                throw new RuntimeException(resource + " cannot be loaded.");
            }
        }
        throw new RuntimeException(resource + " cannot be loaded.");
    }
}

