/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.SafariCustomProfileLauncher;

public class SafariFileBasedLauncher
extends SafariCustomProfileLauncher {
    public SafariFileBasedLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        super(browserOptions, configuration, sessionId, browserLaunchLocation);
    }

    @Override
    protected void launch(String url) {
        String query = LauncherUtils.getQueryString((String)url);
        query = query + "&driverUrl=http://localhost:" + this.getPort() + "/selenium-server/driver/";
        try {
            if (this.browserConfigurationOptions.is("ensureCleanSession")) {
                this.ensureCleanSession();
            }
            String fileUrl = this.createExtractedFiles().toURI().toURL() + "?" + query;
            this.launchSafari(fileUrl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File createExtractedFiles() {
        File coreDir = new File(this.customProfileDir, "core");
        try {
            coreDir.mkdirs();
            ResourceExtractor.extractResourcePath(SafariFileBasedLauncher.class, "/core", coreDir);
            File userExtensions = BrowserOptions.getFile(this.browserConfigurationOptions, "userExtensions");
            if (userExtensions != null) {
                File userExtensionsJavascriptFile = new File(coreDir, "scripts/user-extensions.js");
                FileHandler.copy((File)userExtensions, (File)userExtensionsJavascriptFile);
            }
            return new File(coreDir, "RemoteRunner.html");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

