/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.utils.GridHubConfiguration;
import org.openqa.grid.web.servlet.RegistryBasedServlet;

public class RegistrationServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = -8670670577712086527L;
    private static final Logger log = Logger.getLogger(RegistrationServlet.class.getName());

    public RegistrationServlet() {
        this(null);
    }

    public RegistrationServlet(Registry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        StringBuilder registrationRequest = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            registrationRequest.append(line);
        }
        rd.close();
        log.fine("getting the following registration request  : " + registrationRequest.toString());
        RegistrationRequest server = RegistrationRequest.getNewInstance(registrationRequest.toString());
        GridHubConfiguration hubConfig = this.getRegistry().getConfiguration();
        for (String key : hubConfig.getAllParams().keySet()) {
            if (server.getConfiguration().containsKey(key)) continue;
            server.getConfiguration().put(key, hubConfig.getAllParams().get(key));
        }
        Object proxy = RemoteProxy.getNewInstance(server, this.getRegistry());
        this.reply(response, "ok");
        new Thread(new Runnable((RemoteProxy)proxy){
            final /* synthetic */ RemoteProxy val$proxy;
            {
                this.val$proxy = remoteProxy;
            }

            public void run() {
                RegistrationServlet.this.getRegistry().add(this.val$proxy);
                log.fine("proxy added " + this.val$proxy.getRemoteURL());
            }
        }).start();
    }

    protected void reply(HttpServletResponse response, String content) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        response.getWriter().print(content);
    }
}

