/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.RedirectHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.internal.listeners.CommandListener;
import org.openqa.grid.web.Hub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSession {
    private static final Logger log = Logger.getLogger(TestSession.class.getName());
    private static final int MAX_IDLE_TIME_BEFORE_CONSIDERED_ORPHANED = 5000;
    private final String internalKey;
    private final TestSlot slot;
    private String externalKey = null;
    private long sessionCreatedAt;
    private long lastActivity;
    private final Map<String, Object> requestedCapabilities;
    private Map<String, Object> objects = new HashMap<String, Object>();
    private volatile boolean ignoreTimeout = false;
    private static ThreadSafeClientConnManager connManager;
    private static HttpParams params;

    public String getInternalKey() {
        return this.internalKey;
    }

    TestSession(TestSlot slot, Map<String, Object> requestedCapabilities) {
        this.internalKey = UUID.randomUUID().toString();
        this.slot = slot;
        this.requestedCapabilities = requestedCapabilities;
        this.lastActivity = System.currentTimeMillis();
    }

    public Map<String, Object> getRequestedCapabilities() {
        return this.requestedCapabilities;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
        this.sessionCreatedAt = this.lastActivity;
    }

    public long getInactivityTime() {
        if (this.ignoreTimeout) {
            return 0L;
        }
        return System.currentTimeMillis() - this.lastActivity;
    }

    public boolean isOrphaned() {
        long now = System.currentTimeMillis();
        return now - this.sessionCreatedAt > 5000L && this.sessionCreatedAt == this.lastActivity;
    }

    public TestSlot getSlot() {
        return this.slot;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internalKey == null ? 0 : this.internalKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestSession other = (TestSession)obj;
        return this.internalKey.equals(other.internalKey);
    }

    public String toString() {
        return this.externalKey != null ? "ext. key " + this.externalKey : this.internalKey + " (int. key, remote not contacted yet.)";
    }

    public void forward(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.forward(request, response, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultHttpClient getClient() {
        Class<TestSession> clazz = TestSession.class;
        synchronized (TestSession.class) {
            if (connManager == null) {
                params = new BasicHttpParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)120000);
                HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
                connManager = new ThreadSafeClientConnManager(params, schemeRegistry);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)connManager, params);
            client.setRedirectHandler(new RedirectHandler(){

                public boolean isRedirectRequested(HttpResponse response, HttpContext context) {
                    return false;
                }

                public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
                    return null;
                }
            });
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String forward(HttpServletRequest request, HttpServletResponse response, String content, boolean interceptResponseBody) throws IOException {
        String res;
        block27: {
            BasicHttpRequest proxyRequest;
            BasicHttpEntityEnclosingRequest r;
            res = null;
            if (this.slot.getProxy() instanceof CommandListener) {
                ((CommandListener)((Object)this.slot.getProxy())).beforeCommand(this, request, response);
            }
            this.lastActivity = System.currentTimeMillis();
            URL remoteURL = this.slot.getProxy().getRemoteURL();
            String pathSpec = request.getServletPath() + request.getContextPath();
            String path = request.getRequestURI();
            if (!path.startsWith(pathSpec)) {
                throw new IllegalStateException("Expected path " + path + " to start with pathSpec " + pathSpec);
            }
            String end = path.substring(pathSpec.length());
            String ok = remoteURL + end;
            String uri = new URL(remoteURL, ok).toExternalForm();
            ServletInputStream body = null;
            if (request.getContentLength() > 0 || request.getHeader("Transfer-Encoding") != null) {
                body = request.getInputStream();
            }
            if (content != null) {
                r = new BasicHttpEntityEnclosingRequest(request.getMethod(), uri);
                r.setEntity((HttpEntity)new StringEntity(content));
                proxyRequest = r;
            } else if (body != null) {
                r = new BasicHttpEntityEnclosingRequest(request.getMethod(), uri);
                r.setEntity((HttpEntity)new InputStreamEntity((InputStream)body, (long)request.getContentLength()));
                proxyRequest = r;
            } else {
                proxyRequest = new BasicHttpRequest(request.getMethod(), uri);
            }
            Enumeration e = request.getHeaderNames();
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                if ("Content-Length".equalsIgnoreCase(headerName)) continue;
                proxyRequest.setHeader(headerName, request.getHeader(headerName));
            }
            DefaultHttpClient client = this.getClient();
            HttpHost host = new HttpHost(remoteURL.getHost(), remoteURL.getPort());
            HttpResponse proxyResponse = client.execute(host, (HttpRequest)proxyRequest);
            this.lastActivity = System.currentTimeMillis();
            response.setStatus(proxyResponse.getStatusLine().getStatusCode());
            HttpEntity responseBody = proxyResponse.getEntity();
            for (Header header : proxyResponse.getAllHeaders()) {
                String name = header.getName();
                String value = header.getValue();
                if (name.equalsIgnoreCase("Transfer-Encoding") && value.equalsIgnoreCase("chunked")) continue;
                if (name.equalsIgnoreCase("Location")) {
                    URL returnedLocation = new URL(value);
                    URL driverLocation = remoteURL;
                    String driverPath = driverLocation.getPath();
                    String wrongPath = returnedLocation.getPath();
                    String correctPath = wrongPath.replace(driverPath, "");
                    Hub hub = this.slot.getProxy().getRegistry().getHub();
                    String location = "http://" + hub.getHost() + ":" + hub.getPort() + pathSpec + correctPath;
                    response.setHeader(name, location);
                    continue;
                }
                response.setHeader(name, value);
            }
            if (responseBody == null) break block27;
            InputStream in = responseBody.getContent();
            if (interceptResponseBody) {
                StringBuilder sb = new StringBuilder();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    in.close();
                }
                catch (UnsupportedEncodingException e2) {
                    throw new RuntimeException(e2);
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
                res = sb.toString();
                in = new ByteArrayInputStream(res.getBytes("UTF-8"));
            }
            try {
                ServletOutputStream out = response.getOutputStream();
                try {
                    byte[] rawBody = ByteStreams.toByteArray((InputStream)in);
                    if (!response.containsHeader("Content-Length")) {
                        response.setIntHeader("Content-Length", rawBody.length);
                    }
                    out.write(rawBody);
                    Object var32_37 = null;
                }
                catch (Throwable throwable) {
                    Object var32_38 = null;
                    try {
                        out.close();
                    }
                    catch (IOException e4) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    out.close();
                }
                catch (IOException e4) {}
                Object var35_42 = null;
            }
            catch (Throwable throwable) {
                Object var35_43 = null;
                try {
                    in.close();
                }
                catch (IOException e5) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e5) {}
        }
        if (this.slot.getProxy() instanceof CommandListener) {
            ((CommandListener)((Object)this.slot.getProxy())).afterCommand(this, request, response);
        }
        return res;
    }

    public Object get(String key) {
        return this.objects.get(key);
    }

    public void put(String key, Object value) {
        this.objects.put(key, value);
    }

    public void terminate() {
        this.slot.release();
    }

    void terminateSynchronousFOR_TEST_ONLY() {
        this.slot._release();
    }

    public boolean sendDeleteSessionRequest() {
        if (this.externalKey == null) {
            return false;
        }
        URL remoteURL = this.slot.getProxy().getRemoteURL();
        String uri = remoteURL.toString() + "/session/" + this.externalKey;
        BasicHttpRequest request = new BasicHttpRequest("DELETE", uri);
        DefaultHttpClient client = new DefaultHttpClient();
        boolean ok = false;
        try {
            HttpResponse response = client.execute(new HttpHost(remoteURL.getHost(), remoteURL.getPort()), (HttpRequest)request);
            int code = response.getStatusLine().getStatusCode();
            ok = code >= 200 && code <= 299;
        }
        catch (Throwable e) {
            ok = false;
            log.severe("Error releasing. Server corrupted ?");
        }
        return ok;
    }

    public boolean sendSelenium1TestComplete(TestSession session) throws IOException {
        URL url = this.slot.getProxy().getRemoteURL();
        BasicHttpRequest req = new BasicHttpRequest("POST", url.toExternalForm() + "/?cmd=testComplete&sessionId=" + session.getExternalKey());
        DefaultHttpClient client = new DefaultHttpClient();
        HttpHost host = new HttpHost(url.getHost(), url.getPort());
        HttpResponse response = client.execute(host, (HttpRequest)req);
        boolean ok = false;
        try {
            int code = response.getStatusLine().getStatusCode();
            ok = code >= 200 && code <= 299;
        }
        catch (Throwable e) {
            ok = false;
            log.severe("Error releasing. Server corrupted ?");
        }
        return ok;
    }

    public void setIgnoreTimeout(boolean ignore) {
        if (!ignore) {
            this.lastActivity = System.currentTimeMillis();
        }
        this.ignoreTimeout = ignore;
    }
}

