/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.log;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogRecord;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.server.log.LogFile;

public class SessionLogsToFileRepository {
    private Map<SessionId, LogFile> sessionToLogFileMap = new HashMap<SessionId, LogFile>();

    public void createLogFileAndAddToMap(SessionId sessionId) throws IOException {
        File rcLogFile = File.createTempFile(sessionId.toString(), ".rclog");
        rcLogFile.deleteOnExit();
        LogFile logFile = new LogFile(rcLogFile.getAbsolutePath());
        this.sessionToLogFileMap.put(sessionId, logFile);
    }

    public synchronized void flushRecordsToLogFile(SessionId sessionId, List<LogRecord> records) throws IOException {
        LogFile logFile = this.sessionToLogFileMap.get(sessionId);
        if (logFile == null) {
            this.createLogFileAndAddToMap(sessionId);
            logFile = this.sessionToLogFileMap.get(sessionId);
        }
        logFile.openLogWriter();
        for (LogRecord record : records) {
            logFile.getLogWriter().writeObject(record);
        }
        logFile.closeLogWriter();
    }

    public List<LogRecord> getLogRecords(SessionId sessionId) throws IOException {
        LogFile logFile = this.sessionToLogFileMap.get(sessionId);
        if (logFile == null) {
            return new ArrayList<LogRecord>();
        }
        logFile.openLogReader();
        ObjectInputStream logObjInStream = logFile.getLogReader();
        ArrayList<LogRecord> logRecords = new ArrayList<LogRecord>();
        try {
            LogRecord tmpLogRecord;
            while (null != (tmpLogRecord = (LogRecord)logObjInStream.readObject())) {
                logRecords.add(tmpLogRecord);
            }
        }
        catch (IOException ex) {
            logFile.closeLogReader();
            return logRecords;
        }
        catch (ClassNotFoundException e) {
            logFile.closeLogReader();
            return logRecords;
        }
        logFile.closeLogReader();
        return logRecords;
    }

    public void removeLogFile(SessionId sessionId) {
        LogFile logFile = this.sessionToLogFileMap.get(sessionId);
        this.sessionToLogFileMap.remove(sessionId);
        if (logFile == null) {
            return;
        }
        try {
            logFile.removeLogFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

