/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.http.HttpException;
import org.openqa.jetty.http.HttpFields;
import org.openqa.jetty.http.HttpHandler;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;

public class CachedContentTestHandler
implements HttpHandler {
    private static final long serialVersionUID = -4765843647662493876L;
    HttpContext context;
    boolean started;

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse res) throws HttpException, IOException {
        if (!"/cachedContentTest".equals(pathInContext)) {
            return;
        }
        res.setField("Content-Type", "text/html");
        this.setAlwaysCacheHeaders(res);
        OutputStreamWriter writer = new OutputStreamWriter(res.getOutputStream());
        writer.write("<html><body>");
        writer.write(Long.toString(System.currentTimeMillis()));
        writer.write("</body></html>");
        writer.flush();
        writer.close();
        httpRequest.setHandled(true);
    }

    private void setAlwaysCacheHeaders(HttpResponse res) {
        res.setField("Cache-Control", "max-age=29723626");
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 1);
        res.setField("Expires", HttpFields.formatDate(calendar, false));
        res.setField("Last-Modified", HttpFields.__01Jan1970);
        res.removeField("Pragma");
        res.setField("ETag", "foo");
    }

    @Override
    public String getName() {
        return CachedContentTestHandler.class.getName();
    }

    @Override
    public HttpContext getHttpContext() {
        return this.context;
    }

    @Override
    public void initialize(HttpContext c) {
        this.context = c;
    }

    @Override
    public void start() throws Exception {
        this.started = true;
    }

    @Override
    public void stop() throws InterruptedException {
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }
}

