/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium;

import java.util.logging.Logger;
import org.openqa.grid.common.GridDocHelper;
import org.openqa.grid.common.GridRole;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.GridHubConfiguration;
import org.openqa.grid.internal.utils.SelfRegisteringRemote;
import org.openqa.grid.web.Hub;
import org.openqa.selenium.server.SeleniumServer;

public class GridLauncher {
    private static final Logger log = Logger.getLogger(GridLauncher.class.getName());

    public static void main(String[] args) throws Exception {
        GridRole role = GridRole.find(args);
        switch (role) {
            case NOT_GRID: {
                log.info("Launching a standalone server");
                SeleniumServer.main(args);
                break;
            }
            case HUB: {
                log.info("Launching a selenium grid server");
                try {
                    GridHubConfiguration c = GridHubConfiguration.build(args);
                    Hub h = new Hub(c);
                    h.start();
                }
                catch (GridConfigurationException e) {
                    e.printStackTrace();
                    GridDocHelper.printHelp(e.getMessage());
                }
                break;
            }
            case WEBDRIVER: 
            case REMOTE_CONTROL: {
                log.info("Launching a selenium grid node");
                try {
                    RegistrationRequest c = RegistrationRequest.build(args);
                    SelfRegisteringRemote remote = new SelfRegisteringRemote(c);
                    remote.startRemoteServer();
                    remote.startRegistrationProcess();
                }
                catch (GridConfigurationException e) {
                    e.printStackTrace();
                    GridDocHelper.printHelp(e.getMessage());
                }
                break;
            }
            default: {
                throw new RuntimeException("NI");
            }
        }
    }
}

