/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitlyWait
extends WebDriverHandler
implements JsonParametersAware {
    private volatile long millis;

    public ImplicitlyWait(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.millis = ((Number)allParameters.get("ms")).longValue();
    }

    @Override
    public ResultType call() throws Exception {
        this.getDriver().manage().timeouts().implicitlyWait(this.millis, TimeUnit.MILLISECONDS);
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[implicitly wait: %s]", this.millis);
    }
}

