/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.exception.NewSessionException;
import org.openqa.grid.internal.utils.ForwardConfiguration;
import org.openqa.grid.web.servlet.handler.RequestHandler;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.jetty.jetty.servlet.ServletHttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverRequestHandler
extends RequestHandler {
    private static final Logger log = Logger.getLogger(WebDriverRequestHandler.class.getName());

    protected WebDriverRequestHandler(HttpServletRequest request, HttpServletResponse response, Registry registry) {
        super(request, response, registry);
    }

    @Override
    public RequestType extractRequestType() {
        if ("/session".equals(this.getRequest().getPathInfo())) {
            return RequestType.START_SESSION;
        }
        if (this.getRequest().getMethod().equalsIgnoreCase("DELETE")) {
            ExternalSessionKey externalKey = ExternalSessionKey.fromWebDriverRequest(this.getRequest().getPathInfo());
            if (this.getRequest().getPathInfo().endsWith("/session/" + externalKey.getKey())) {
                return RequestType.STOP_SESSION;
            }
        }
        return RequestType.REGULAR;
    }

    @Override
    public ExternalSessionKey extractSession() {
        if (this.getRequestType() == RequestType.START_SESSION) {
            throw new IllegalAccessError("Cannot call that method of a new session request.");
        }
        String path = this.getRequest().getPathInfo();
        return ExternalSessionKey.fromWebDriverRequest(path);
    }

    @Override
    public Map<String, Object> extractDesiredCapability() {
        String json = this.getRequestBody();
        HashMap<String, Object> desiredCapability = new HashMap<String, Object>();
        try {
            JSONObject map = new JSONObject(json);
            JSONObject dc = map.getJSONObject("desiredCapabilities");
            Iterator iterator = dc.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = dc.get(key);
                if (value == JSONObject.NULL) {
                    value = null;
                }
                desiredCapability.put(key, value);
            }
        }
        catch (JSONException e) {
            throw new GridException("Cannot extract a capabilities from the request " + json);
        }
        return desiredCapability;
    }

    @Override
    public ExternalSessionKey forwardNewSessionRequestAndUpdateRegistry(TestSession session) throws NewSessionException {
        try {
            JSONObject c = new JSONObject();
            c.put("desiredCapabilities", session.getRequestedCapabilities());
            String content = c.toString();
            ForwardConfiguration config = new ForwardConfiguration();
            config.setProtocol(SeleniumProtocol.WebDriver);
            config.setNewSessionRequest(true);
            config.setContentOverWrite(content);
            session.forward(this.getRequest(), this.getResponse(), config);
        }
        catch (IOException e) {
            throw new NewSessionException("Error forwarding the request " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new NewSessionException("Error with the request " + e.getMessage(), e);
        }
        if (this.getResponse().containsHeader("Location")) {
            String location = ((ServletHttpResponse)this.getResponse()).getHttpResponse().getField("Location");
            ExternalSessionKey res = ExternalSessionKey.fromWebDriverRequest(location);
            if (res != null) {
                return res;
            }
            throw new NewSessionException("couldn't extract the new session from the response header.");
        }
        throw new NewSessionException("Error, header should contain Location ");
    }
}

