/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.web.servlet.RegistryBasedServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyStatusServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = 7653463271803124556L;

    public ProxyStatusServlet() {
        this(null);
    }

    public ProxyStatusServlet(Registry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        try {
            JSONObject res = this.getResponse(request);
            response.getWriter().print(res);
            response.getWriter().close();
        }
        catch (JSONException e) {
            throw new GridException(e.getMessage());
        }
    }

    private JSONObject getResponse(HttpServletRequest request) throws IOException, JSONException {
        String id;
        JSONObject requestJSON = null;
        if (request.getInputStream() != null) {
            String line;
            BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
            StringBuilder s = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                s.append(line);
            }
            rd.close();
            String json = s.toString();
            if (json != null && !"".equals(json)) {
                requestJSON = new JSONObject(json);
            }
        }
        JSONObject res = new JSONObject();
        res.put("success", false);
        if (requestJSON == null) {
            id = request.getParameter("id");
        } else {
            if (!requestJSON.has("id")) {
                res.put("msg", (Object)"you need to specify at least an id when call the node  status service.");
                return res;
            }
            id = requestJSON.getString("id");
        }
        try {
            URL u = new URL(id);
            id = "http://" + u.getHost() + ":" + u.getPort();
        }
        catch (MalformedURLException ignore) {
            // empty catch block
        }
        RemoteProxy proxy = this.getRegistry().getProxyById(id);
        if (proxy == null) {
            res.put("msg", (Object)("Cannot find proxy with ID =" + id + " in the registry."));
            return res;
        }
        res.put("msg", (Object)"proxy found !");
        res.put("success", true);
        res.put("id", (Object)proxy.getId());
        res.put("request", (Object)proxy.getOriginalRegistrationRequest().getAssociatedJSON());
        if (requestJSON != null) {
            List<String> methods = this.getExtraMethodsRequested(requestJSON);
            ArrayList<String> errors = new ArrayList<String>();
            for (String method : methods) {
                try {
                    Object o = this.getValueByReflection(proxy, method);
                    res.put(method, o);
                }
                catch (Throwable t) {
                    errors.add(t.getMessage());
                }
            }
            if (!errors.isEmpty()) {
                res.put("success", false);
                res.put("errors", (Object)((Object)errors).toString());
            }
        }
        return res;
    }

    private Object getValueByReflection(RemoteProxy proxy, String method) {
        Class[] argsClass = new Class[]{};
        try {
            Method m = proxy.getClass().getDeclaredMethod(method, argsClass);
            return m.invoke((Object)proxy, new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getClass() + " - " + e.getMessage());
        }
    }

    private List<String> getExtraMethodsRequested(JSONObject request) {
        ArrayList<String> res = new ArrayList<String>();
        Iterator iterator = request.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if ("id".equals(key)) continue;
            res.add(key);
        }
        return res;
    }
}

