/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.renderer;

import com.google.common.base.Charsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.server.renderer.JsonErrorExceptionResult;
import org.openqa.selenium.remote.server.rest.Handler;
import org.openqa.selenium.remote.server.rest.Renderer;

public class JsonpResult
implements Renderer {
    private final String responsePropertyName;
    private final String callbackPropertyName;
    private final JsonErrorExceptionResult exceptionResult;

    public JsonpResult(String responsePropertyName, String errorPropertyName, String callbackPropertyName) {
        this.callbackPropertyName = callbackPropertyName;
        this.responsePropertyName = responsePropertyName.startsWith(":") ? responsePropertyName.substring(1) : responsePropertyName;
        this.exceptionResult = new JsonErrorExceptionResult(errorPropertyName, responsePropertyName);
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Handler handler) throws Exception {
        Object result = request.getAttribute(this.responsePropertyName);
        if (result == null) {
            result = this.exceptionResult.prepareResponseObject(request);
        }
        result = new BeanToJsonConverter().convert(result);
        String quoted = new JSONArray().put(result).toString();
        quoted = quoted.substring(1, quoted.length() - 1);
        String renderedResponse = String.format("%s(%s);\n", request.getAttribute(this.callbackPropertyName), quoted);
        byte[] data = Charsets.UTF_8.encode(renderedResponse).array();
        int length = data.length;
        while (data[length - 1] == 0) {
            --length;
        }
        response.setContentType("text/javascript");
        response.setCharacterEncoding(Charsets.UTF_8.toString());
        response.setContentLength(length);
        response.getOutputStream().write(data);
        response.getOutputStream().flush();
    }
}

