/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.IOException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;

public class CustomBrowserLauncher
extends AbstractBrowserLauncher {
    protected Process process;
    protected String commandPath;

    public CustomBrowserLauncher(String commandPath, String sessionId, RemoteControlConfiguration configuration, Capabilities browserOptions) {
        super(sessionId, configuration, browserOptions);
        this.commandPath = commandPath;
        this.sessionId = sessionId;
    }

    public void close() {
        if (this.process == null) {
            return;
        }
        AsyncExecute.killProcess((Process)this.process);
    }

    public Process getProcess() {
        return this.process;
    }

    protected void launch(String url) {
        this.exec(this.commandPath + " " + url);
    }

    protected void exec(String command) {
        try {
            this.process = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            throw new RuntimeException("Error starting browser by executing command " + command + ": " + e);
        }
    }
}

