/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.internal.utils.HtmlRenderer;

public class DefaultHtmlRenderer
implements HtmlRenderer {
    private RemoteProxy proxy;

    private DefaultHtmlRenderer() {
    }

    public DefaultHtmlRenderer(RemoteProxy proxy) {
        this.proxy = proxy;
    }

    public String renderSummary() {
        StringBuilder builder = new StringBuilder();
        builder.append("<fieldset>");
        builder.append("<legend>").append(this.proxy.getClass().getSimpleName()).append("</legend>");
        builder.append("listening on ").append(this.proxy.getRemoteHost());
        if (this.proxy.getTimeOut() > 0) {
            int inSec = this.proxy.getTimeOut() / 1000;
            builder.append("test session time out after ").append(inSec).append(" sec.");
        }
        builder.append("<br>Supports up to <b>").append(this.proxy.getMaxNumberOfConcurrentTestSessions()).append("</b> concurrent tests from : </u><br>");
        for (TestSlot slot : this.proxy.getTestSlots()) {
            builder.append(slot.getCapabilities().containsKey("browserName") ? slot.getCapabilities().get("browserName") : slot.getCapabilities().get("applicationName"));
            builder.append("protocol:" + (Object)((Object)slot.getProtocol()) + "<br>");
            TestSession session = slot.getSession();
            builder.append(session == null ? "(free)" : "(busy, session " + session + ")");
            builder.append("<br>");
        }
        builder.append("</fieldset>");
        return builder.toString();
    }
}

