/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.TestSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class ActiveTestSessions {
    private final Set<TestSession> activeTestSessions = new CopyOnWriteArraySet<TestSession>();

    ActiveTestSessions() {
    }

    public boolean add(TestSession testSession) {
        return this.activeTestSessions.add(testSession);
    }

    public boolean remove(TestSession o) {
        return this.activeTestSessions.remove(o);
    }

    public TestSession findSessionByInternalKey(String internalKey) {
        if (internalKey == null) {
            return null;
        }
        for (TestSession session : this.activeTestSessions) {
            if (!internalKey.equals(session.getInternalKey())) continue;
            return session;
        }
        return null;
    }

    public TestSession findSessionByExternalKey(ExternalSessionKey externalkey) {
        if (externalkey == null) {
            return null;
        }
        for (TestSession session : this.activeTestSessions) {
            if (!externalkey.equals(session.getExternalKey())) continue;
            return session;
        }
        return null;
    }

    public Set<TestSession> unmodifiableSet() {
        return Collections.unmodifiableSet(this.activeTestSessions);
    }
}

