/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;

public class KnownElements {
    private final Map<String, WebElement> elements = new HashMap<String, WebElement>();
    private int nextId;

    public String add(WebElement element) {
        String id = this.getNextId();
        this.elements.put(id, this.proxyElement(element, id));
        return id;
    }

    public WebElement get(String elementId) {
        return this.elements.get(elementId);
    }

    private String getNextId() {
        return String.valueOf(this.nextId++);
    }

    private WebElement proxyElement(final WebElement element, final String id) {
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
                if ("getId".equals(method.getName())) {
                    return id;
                }
                if ("getWrappedElement".equals(method.getName())) {
                    return element;
                }
                return method.invoke((Object)element, objects);
            }
        };
        Class[] proxyThese = element instanceof Locatable ? new Class[]{WebElement.class, ProxiedElement.class, Locatable.class} : new Class[]{WebElement.class, ProxiedElement.class};
        return (WebElement)Proxy.newProxyInstance(element.getClass().getClassLoader(), proxyThese, handler);
    }

    public static interface ProxiedElement
    extends WrapsElement {
        public String getId();
    }
}

