/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.web.servlet.ResourceServlet;
import org.openqa.grid.web.utils.ExtraServletUtil;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.jetty.Server;
import org.openqa.jetty.jetty.servlet.ServletHandler;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.server.SeleniumServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelfRegisteringRemote {
    private static final Logger log = Logger.getLogger(SelfRegisteringRemote.class.getName());
    private RegistrationRequest nodeConfig;
    private SeleniumServer server;

    public SelfRegisteringRemote(RegistrationRequest config) {
        this.nodeConfig = config;
    }

    public URL getRemoteURL() {
        String url;
        String base = "http://" + this.nodeConfig.getConfiguration().get("host") + ":" + this.nodeConfig.getConfiguration().get("port");
        switch (this.nodeConfig.getRole()) {
            case REMOTE_CONTROL: {
                url = base + "/selenium-server/driver";
                break;
            }
            case WEBDRIVER: {
                url = base + "/wd/hub";
                break;
            }
            default: {
                throw new GridConfigurationException("Cannot launch a node with role " + (Object)((Object)this.nodeConfig.getRole()));
            }
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new GridConfigurationException("error building the node url " + e.getMessage(), e);
        }
    }

    public void startRemoteServer() throws Exception {
        List<String> servlets;
        this.nodeConfig.validate();
        System.setProperty("org.openqa.jetty.http.HttpRequest.maxFormContentSize", "0");
        this.server = new SeleniumServer(this.nodeConfig.getRemoteControlConfiguration());
        Server jetty = this.server.getServer();
        String servletsStr = (String)this.nodeConfig.getConfiguration().get("servlets");
        if (servletsStr != null && (servlets = Arrays.asList(servletsStr.split(","))) != null) {
            HttpContext extra = new HttpContext();
            extra.setContextPath("/extra");
            ServletHandler handler = new ServletHandler();
            handler.addServlet("/resources/*", ResourceServlet.class.getName());
            for (String s : servlets) {
                Class<? extends Servlet> servletClass = ExtraServletUtil.createServlet(s);
                if (servletClass == null) continue;
                String path = "/" + servletClass.getSimpleName() + "/*";
                String clazz = servletClass.getCanonicalName();
                handler.addServlet(path, clazz);
                log.info("started extra node servlet visible at : http://xxx:" + this.nodeConfig.getConfiguration().get("port") + "/extra" + path);
            }
            extra.addHandler(handler);
            jetty.addContext(extra);
        }
        this.server.boot();
    }

    public void stopRemoteServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void deleteAllBrowsers() {
        this.nodeConfig.getCapabilities().clear();
    }

    public void addBrowser(DesiredCapabilities cap, int instances) {
        String s = cap.getBrowserName();
        if (s == null || "".equals(s)) {
            throw new InvalidParameterException(cap + " does seems to be a valid browser.");
        }
        cap.setPlatform(Platform.getCurrent());
        cap.setCapability("maxInstances", (Object)instances);
        this.nodeConfig.getCapabilities().add(cap);
    }

    public void sendRegistrationRequest() {
        this.registerToHub(false);
    }

    public void startRegistrationProcess() {
        log.info("using the json request : " + this.nodeConfig.toJSON());
        Boolean register = (Boolean)this.nodeConfig.getConfiguration().get("register");
        if (!register.booleanValue()) {
            log.info("no registration sent ( register = false )");
        } else {
            final Integer o = (Integer)this.nodeConfig.getConfiguration().get("registerCycle");
            if (o != null && o > 0) {
                new Thread(new Runnable(){

                    public void run() {
                        boolean first = true;
                        log.info("starting auto register thread. Will try to register every " + o + " ms.");
                        while (true) {
                            try {
                                boolean checkForPresence = true;
                                if (first) {
                                    first = false;
                                    checkForPresence = false;
                                }
                                SelfRegisteringRemote.this.registerToHub(checkForPresence);
                            }
                            catch (GridException e) {
                                log.info("couldn't register this node : " + e.getMessage());
                            }
                            try {
                                Thread.sleep(o.intValue());
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                }).start();
            } else {
                this.registerToHub(false);
            }
        }
    }

    public void setTimeout(int timeout, int cycle) {
        this.nodeConfig.getConfiguration().put("timeout", timeout);
        this.nodeConfig.getConfiguration().put("cleanUpCycle", cycle);
    }

    public void setMaxConcurrent(int max) {
        this.nodeConfig.getConfiguration().put("maxSession", max);
    }

    public Map<String, Object> getConfiguration() {
        return this.nodeConfig.getConfiguration();
    }

    private void registerToHub(boolean checkPresenceFirst) {
        block4: {
            boolean ok;
            boolean bl = checkPresenceFirst ? !SelfRegisteringRemote.isAlreadyRegistered(this.nodeConfig) : (ok = true);
            if (ok) {
                String tmp = "http://" + this.nodeConfig.getConfiguration().get("hubHost") + ":" + this.nodeConfig.getConfiguration().get("hubPort") + "/grid/register";
                try {
                    URL registration = new URL(tmp);
                    log.info("Registering the node to hub :" + registration);
                    BasicHttpEntityEnclosingRequest r = new BasicHttpEntityEnclosingRequest("POST", registration.toExternalForm());
                    String json = this.nodeConfig.toJSON();
                    r.setEntity((HttpEntity)new StringEntity(json));
                    DefaultHttpClient client = new DefaultHttpClient();
                    HttpHost host = new HttpHost(registration.getHost(), registration.getPort());
                    HttpResponse response = client.execute(host, (HttpRequest)r);
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new RuntimeException("Error sending the registration request.");
                    }
                    break block4;
                }
                catch (Exception e) {
                    throw new GridException("Error sending the registration request.", e);
                }
            }
            log.fine("hub is already present on the hub. Skipping registration.");
        }
    }

    private static boolean isAlreadyRegistered(RegistrationRequest node) {
        try {
            String tmp = "http://" + node.getConfiguration().get("hubHost") + ":" + node.getConfiguration().get("hubPort") + "/grid/api/proxy";
            URL api = new URL(tmp);
            HttpHost host = new HttpHost(api.getHost(), api.getPort());
            DefaultHttpClient client = new DefaultHttpClient();
            BasicHttpRequest r = new BasicHttpRequest("GET", api.toExternalForm() + "?id=" + node.getConfiguration().get("url"));
            HttpResponse response = client.execute(host, (HttpRequest)r);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new GridException("hub down or not responding.");
            }
            JSONObject o = SelfRegisteringRemote.extractObject(response);
            return (Boolean)o.get("success");
        }
        catch (Exception e) {
            throw new GridException("hub down or not responding.");
        }
    }

    private static JSONObject extractObject(HttpResponse resp) throws IOException, JSONException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));
        StringBuilder s = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            s.append(line);
        }
        rd.close();
        return new JSONObject(s.toString());
    }
}

