/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.internal.GridException;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.internal.listeners.TimeoutListener;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.grid.internal.utils.DefaultCapabilityMatcher;
import org.openqa.grid.internal.utils.DefaultHtmlRenderer;
import org.openqa.grid.internal.utils.HtmlRenderer;
import org.openqa.grid.web.Hub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteProxy
implements Comparable<RemoteProxy> {
    private RegistrationRequest request;
    private String id;
    private int cleanUpCycle = -1;
    private int timeOut = -1;
    private static final Logger log = Logger.getLogger(RemoteProxy.class.getName());
    protected URL remoteURL;
    private Map<String, Object> config;
    private List<TestSlot> testSlots = new ArrayList<TestSlot>();
    private int maxConcurrentSession = 0;
    private Registry registry;
    private CapabilityMatcher capabilityHelper = new DefaultCapabilityMatcher();
    private boolean stop = false;
    private final HtmlRenderer renderer = new DefaultHtmlRenderer(this);

    public List<TestSlot> getTestSlots() {
        return this.testSlots;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public CapabilityMatcher getCapabilityHelper() {
        return this.capabilityHelper;
    }

    public void setCapabilityHelper(CapabilityMatcher capabilityHelper) {
        this.capabilityHelper = capabilityHelper;
    }

    public RemoteProxy(RegistrationRequest request) {
        this.request = request;
        this.config = request.getConfiguration();
        String url = (String)this.config.get("url");
        if (url == null) {
            this.remoteURL = null;
            log.warning("URL was null. Not a problem if you set a meaningful ID.");
        } else {
            try {
                this.remoteURL = new URL(url);
                this.id = this.remoteURL.toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new GridException("Not a correct url to register a remote : " + url);
            }
        }
        this.maxConcurrentSession = request.getConfigAsInt("maxSession", 1);
        this.cleanUpCycle = Hub.getGrid1Config().get("cleanupCycle") == null ? request.getConfigAsInt("cleanUpCycle", -1) : Hub.getGrid1Config().get("cleanupCycle").intValue();
        this.timeOut = Hub.getGrid1Config().get("timeout") == null ? request.getConfigAsInt("timeout", -1) : Hub.getGrid1Config().get("timeout").intValue();
        List<Map<String, Object>> capabilities = request.getCapabilities();
        for (Map<String, Object> capability : capabilities) {
            Object maxInstance = capability.get("maxInstances");
            if (maxInstance == null) {
                log.warning("Max instance not specified. Using default = 1 instance");
                maxInstance = "1";
            }
            int value = new Integer(maxInstance.toString());
            for (int i = 0; i < value; ++i) {
                this.testSlots.add(new TestSlot(this, capability));
            }
        }
        if (this instanceof TimeoutListener && this.cleanUpCycle > 0 && this.timeOut > 0) {
            log.fine("starting cleanup thread");
            new Thread(new CleanUpThread(this)).start();
        }
    }

    public String getId() {
        if (this.id == null) {
            throw new RuntimeException("Bug. Trying to use the id on a proxy but it hasn't been set.");
        }
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public void teardown() {
        this.stop = true;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public RegistrationRequest getOriginalRegistrationRequest() {
        return this.request;
    }

    public int getMaxNumberOfConcurrentTestSessions() {
        return this.maxConcurrentSession;
    }

    public URL getRemoteURL() {
        return this.remoteURL;
    }

    public TestSession getNewSession(Map<String, Object> requestedCapability) {
        if (!this.hasCapability(requestedCapability)) {
            return null;
        }
        int totalUsed = this.getTotalUsed();
        if (totalUsed >= this.maxConcurrentSession) {
            return null;
        }
        for (TestSlot testslot : this.testSlots) {
            TestSession session = testslot.getNewSession(requestedCapability);
            if (session == null) continue;
            return session;
        }
        return null;
    }

    public int getTotalUsed() {
        int totalUsed = 0;
        for (TestSlot slot : this.testSlots) {
            if (slot.getSession() == null) continue;
            ++totalUsed;
        }
        return totalUsed;
    }

    boolean hasCapability(Map<String, Object> requestedCapability) {
        for (TestSlot slot : this.testSlots) {
            if (!slot.matches(requestedCapability)) continue;
            return true;
        }
        return false;
    }

    protected boolean isBusy() {
        return this.getTotalUsed() != 0;
    }

    public static final <T extends RemoteProxy> T getNewInstance(RegistrationRequest request) {
        try {
            String proxyClass = request.getRemoteProxyClass();
            if (proxyClass == null) {
                log.fine("No proxy class. Using default");
                proxyClass = RemoteProxy.class.getCanonicalName();
            }
            Class<?> clazz = Class.forName(proxyClass);
            log.fine("Using class " + clazz.getName());
            Object[] args = new Object[]{request};
            Class[] argsClass = new Class[]{RegistrationRequest.class};
            Constructor<?> c = clazz.getConstructor(argsClass);
            Object proxy = c.newInstance(args);
            if (proxy instanceof RemoteProxy) {
                return (T)((RemoteProxy)proxy);
            }
            throw new InvalidParameterException("Error:" + proxy.getClass() + " isn't a remote proxy");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidParameterException("Error:" + e.getMessage());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteProxy other = (RemoteProxy)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    public int compareTo(RemoteProxy o) {
        if (o == null) {
            return -1;
        }
        return this.getTotalUsed() - o.getTotalUsed();
    }

    public String toString() {
        return "URL :" + this.getRemoteURL() + (this.timeOut != -1 ? " time out : " + this.timeOut : "");
    }

    public HtmlRenderer getHtmlRender() {
        return this.renderer;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    private class CleanUpThread
    implements Runnable {
        private RemoteProxy proxy;

        public CleanUpThread(RemoteProxy proxy) {
            this.proxy = proxy;
        }

        public void run() {
            log.fine("cleanup thread starting...");
            while (!this.proxy.stop) {
                try {
                    Thread.sleep(RemoteProxy.this.cleanUpCycle);
                }
                catch (InterruptedException e) {
                    log.severe("clean up thread died. " + e.getMessage());
                }
                for (TestSlot slot : RemoteProxy.this.testSlots) {
                    try {
                        long inactivity;
                        boolean hasTimedOut;
                        TestSession session = slot.getSession();
                        if (session == null || !(hasTimedOut = (inactivity = session.getInactivityTime()) > (long)RemoteProxy.this.timeOut)) continue;
                        log.warning("session " + session + " has TIMED OUT and will be released");
                        ((TimeoutListener)((Object)this.proxy)).beforeRelease(session);
                        session.terminate();
                    }
                    catch (Throwable t) {
                        log.warning("Error executing the timeout when cleaning up slot " + slot + t.getMessage());
                    }
                }
            }
        }
    }
}

