/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationRequest {
    private String id;
    private String name;
    private String description;
    private List<Map<String, Object>> capabilities = Lists.newArrayList();
    private Map<String, Object> configuration = Maps.newHashMap();
    private static final Logger log = Logger.getLogger(RegistrationRequest.class.getName());
    public static final String APP = "applicationName";
    public static final String MAX_INSTANCES = "maxInstances";
    public static final String BROWSER = "browserName";
    public static final String PLATFORM = "platform";
    public static final String VERSION = "version";
    public static final String PROXY_CLASS = "proxy";
    public static final String CLEAN_UP_CYCLE = "cleanUpCycle";
    public static final String TIME_OUT = "timeout";
    public static final String REMOTE_URL = "url";
    public static final String MAX_SESSION = "maxSession";
    public static final String AUTO_REGISTER = "register";
    public static final String MAX_TESTS_BEFORE_CLEAN = "maxTestBeforeClean";
    public static final String CLEAN_SNAPSHOT = "cleanSnapshot";

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Map<String, Object>> getCapabilities() {
        return this.capabilities;
    }

    public void addDesiredCapabilitiy(Map<String, ?> c) {
        this.capabilities.add(c);
    }

    public void setCapabilities(List<Map<String, Object>> capabilities) {
        this.capabilities = capabilities;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public String toJSON() {
        JSONObject res = this.getAssociatedJSON();
        return res.toString();
    }

    public JSONObject getAssociatedJSON() {
        JSONObject res = new JSONObject();
        try {
            res.put("class", (Object)this.getClass().getCanonicalName());
            res.put("id", (Object)this.id);
            res.put("name", (Object)this.name);
            res.put("description", (Object)this.description);
            res.put("configuration", this.configuration);
            res.put("capabilities", this.capabilities);
        }
        catch (JSONException e) {
            throw new RuntimeException("Error encoding to JSON " + e.getMessage(), e);
        }
        return res;
    }

    public String getConfigAsString(String param) {
        Object res = this.configuration.get(param);
        return res == null ? null : res.toString();
    }

    public int getConfigAsInt(String param, int defaultValue) {
        Object o = this.configuration.get(param);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return i;
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (Throwable t) {
            log.warning("Error." + this.name + " is supposed to be an int. Keeping default of " + defaultValue);
            return defaultValue;
        }
    }

    public static RegistrationRequest getNewInstance(String json) {
        RegistrationRequest request = new RegistrationRequest();
        try {
            JSONObject o = new JSONObject(json);
            if (o.has("id")) {
                request.setId(o.getString("id"));
            }
            if (o.has("name")) {
                request.setName(o.getString("name"));
            }
            if (o.has("description")) {
                request.setDescription(o.getString("description"));
            }
            JSONObject config = o.getJSONObject("configuration");
            HashMap configuration = Maps.newHashMap();
            Iterator iterator = config.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                configuration.put(key, config.get(key));
            }
            request.setConfiguration(configuration);
            JSONArray capabilities = o.getJSONArray("capabilities");
            for (int i = 0; i < capabilities.length(); ++i) {
                JSONObject capability = capabilities.getJSONObject(i);
                HashMap cap = Maps.newHashMap();
                Iterator iterator2 = capability.keys();
                while (iterator2.hasNext()) {
                    String key = (String)iterator2.next();
                    cap.put(key, capability.get(key));
                }
                request.capabilities.add(cap);
            }
            return request;
        }
        catch (JSONException e) {
            return RegistrationRequest.parseGrid1Request(json);
        }
    }

    public String getRemoteProxyClass() {
        Object o = this.getConfiguration().get(PROXY_CLASS);
        return o == null ? null : o.toString();
    }

    private static RegistrationRequest parseGrid1Request(String clientRequest) {
        String[] parts;
        HashMap registrationInfo = Maps.newHashMap();
        for (String part : parts = clientRequest.split("&")) {
            String[] configItem = part.split("=");
            if (configItem.length != 2) {
                throw new InvalidParameterException();
            }
            try {
                registrationInfo.put(URLDecoder.decode(configItem[0], "UTF-8"), URLDecoder.decode(configItem[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.warning(String.format("Unable to decode registration request portion: %s", part));
            }
        }
        if (registrationInfo.get("port") != null && registrationInfo.get("environment") != null) {
            RegistrationRequest request = new RegistrationRequest();
            HashMap configuration = Maps.newHashMap();
            configuration.put(PROXY_CLASS, "org.openqa.grid.selenium.proxy.SeleniumRemoteProxy");
            configuration.put(REMOTE_URL, String.format("http://%s:%s/selenium-server/driver", registrationInfo.get("host"), registrationInfo.get("port")));
            request.setConfiguration(configuration);
            HashMap cap = Maps.newHashMap();
            cap.put(BROWSER, registrationInfo.get("environment"));
            cap.put("environment", registrationInfo.get("environment"));
            request.capabilities.add(cap);
            return request;
        }
        throw new InvalidParameterException();
    }
}

