/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.log;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.openqa.selenium.server.log.SessionLogsToFileRepository;

public class PerSessionLogHandler
extends Handler {
    private final Map<String, List<LogRecord>> perSessionRecords;
    private final Map<Long, List<LogRecord>> perThreadTempRecords;
    private final Formatter formatter;
    private Map<Long, String> threadToSessionMap;
    private Map<String, Long> sessionToThreadMap;
    private SessionLogsToFileRepository logFileRepository;
    private int capacity;

    public PerSessionLogHandler(int capacity, Level minimumLevel, Formatter formatter) {
        this.capacity = capacity;
        this.formatter = formatter;
        this.perSessionRecords = new HashMap<String, List<LogRecord>>();
        this.perThreadTempRecords = new HashMap<Long, List<LogRecord>>();
        this.threadToSessionMap = new HashMap<Long, String>();
        this.sessionToThreadMap = new HashMap<String, Long>();
        this.logFileRepository = new SessionLogsToFileRepository();
    }

    public synchronized void publish(LogRecord record) {
        long threadId = Thread.currentThread().getId();
        String sessionId = this.threadToSessionMap.get(threadId);
        if (sessionId != null) {
            List<LogRecord> records = this.perSessionRecords.get(sessionId);
            if (records == null) {
                records = new ArrayList<LogRecord>();
            }
            records.add(record);
            this.perSessionRecords.put(sessionId, records);
            if (records.size() > this.capacity) {
                try {
                    this.logFileRepository.flushRecordsToLogFile(sessionId, records);
                    records.clear();
                    this.perSessionRecords.put(sessionId, records);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            List<LogRecord> records = this.perThreadTempRecords.get(threadId);
            if (records == null) {
                records = new ArrayList<LogRecord>();
            }
            records.add(record);
            this.perThreadTempRecords.put(threadId, records);
        }
    }

    public void flush() {
    }

    public synchronized void close() throws SecurityException {
        this.perSessionRecords.clear();
        this.perThreadTempRecords.clear();
    }

    private LogRecord[] records(String sessionId) throws IOException {
        List<LogRecord> logFileRecords = this.logFileRepository.getLogRecords(sessionId);
        List<LogRecord> records = this.perSessionRecords.get(sessionId);
        logFileRecords.addAll(records);
        return logFileRecords.toArray(new LogRecord[0]);
    }

    private String formattedRecords(String sessionId) throws IOException {
        StringWriter writer = new StringWriter();
        for (LogRecord record : this.records(sessionId)) {
            writer.append(this.formatter.format(record));
        }
        return writer.toString();
    }

    public synchronized void setThreadToSessionMapping(long threadId, String sessionId) {
        if (this.threadToSessionMap.get(threadId) == null || this.threadToSessionMap.get(threadId).equals(sessionId)) {
            this.threadToSessionMap.put(threadId, sessionId);
            this.sessionToThreadMap.put(sessionId, threadId);
        }
    }

    public synchronized void clearThreadToSessionMapping(long threadId) {
        String sessionId = this.threadToSessionMap.get(threadId);
        if (sessionId != null) {
            this.threadToSessionMap.remove(threadId);
            this.sessionToThreadMap.remove(sessionId);
        }
    }

    public synchronized void clearSessionLogRecords(String sessionId) throws IOException {
        Long threadId = this.sessionToThreadMap.get(sessionId);
        String sessionIdForThread = this.threadToSessionMap.get(threadId);
        if (threadId != null && sessionIdForThread != null && sessionIdForThread.equals(sessionId)) {
            this.threadToSessionMap.remove(threadId);
            this.sessionToThreadMap.remove(sessionId);
        }
        this.perSessionRecords.remove(sessionId);
        this.logFileRepository.removeLogFile(sessionId);
    }

    public synchronized void copyThreadTempLogsToSessionLogs(String sessionId, long threadId) {
        List<LogRecord> records = this.perThreadTempRecords.get(threadId);
        ArrayList<LogRecord> sessionRecords = new ArrayList<LogRecord>();
        if (this.perSessionRecords.get(sessionId) == null && records != null) {
            sessionRecords.addAll(records);
            this.perSessionRecords.put(sessionId, sessionRecords);
            this.perThreadTempRecords.remove(threadId);
        }
    }

    public synchronized String getLog(String sessionId) throws IOException {
        String logs = this.formattedRecords(sessionId);
        logs = "\n<RC_Logs RC_Session_ID=" + sessionId + ">\n" + logs + "\n</RC_Logs>\n";
        return logs;
    }
}

