/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.interactions;

import java.util.Map;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Keys;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendModifierKey
extends WebDriverHandler
implements JsonParametersAware {
    private String key;
    private boolean isDown;

    public SendModifierKey(DriverSessions sessions) {
        super(sessions);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.key = (String)allParameters.get("value");
        this.isDown = (Boolean)allParameters.get("isdown");
    }

    @Override
    public ResultType call() throws Exception {
        Keyboard keyboard = ((HasInputDevices)this.getDriver()).getKeyboard();
        Keys[] modifiers = new Keys[]{Keys.SHIFT, Keys.CONTROL, Keys.ALT};
        Keys keyToSend = null;
        for (Keys modifier : modifiers) {
            if (!this.key.equals(modifier.toString())) continue;
            keyToSend = modifier;
        }
        if (this.isDown) {
            keyboard.pressKey(keyToSend);
        } else {
            keyboard.releaseKey(keyToSend);
        }
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[send modifier key: %s, %s]", this.key, this.isDown);
    }
}

