/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.AsyncExecute;
import org.openqa.selenium.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.internal.Trace;
import org.openqa.selenium.internal.TraceFactory;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.server.BrowserSessionFactory;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

public class HTMLLauncher
implements HTMLResultsListener {
    static Trace log = TraceFactory.getTrace(HTMLLauncher.class);
    private SeleniumServer remoteControl;
    private HTMLTestResults results;

    public HTMLLauncher(SeleniumServer remoteControl) {
        this.remoteControl = remoteControl;
    }

    public String runHTMLSuite(String browser, String browserURL, String suiteURL, File outputFile, long timeoutInSeconds, boolean multiWindow) throws IOException {
        return this.runHTMLSuite(browser, browserURL, suiteURL, outputFile, timeoutInSeconds, multiWindow, "info");
    }

    protected BrowserLauncher getBrowserLauncher(String browser, String sessionId, RemoteControlConfiguration configuration, Capabilities browserOptions) {
        BrowserLauncherFactory blf = new BrowserLauncherFactory();
        return blf.getBrowserLauncher(browser, sessionId, configuration, browserOptions);
    }

    protected void sleepTight(long timeoutInMs) {
        long now = System.currentTimeMillis();
        long end = now + timeoutInMs;
        while (this.results == null && System.currentTimeMillis() < end) {
            AsyncExecute.sleepTight((long)500L);
        }
    }

    protected FileWriter getFileWriter(File outputFile) throws IOException {
        return new FileWriter(outputFile);
    }

    protected void writeResults(File outputFile) throws IOException {
        if (outputFile != null) {
            FileWriter fw = this.getFileWriter(outputFile);
            this.results.write(fw);
            fw.close();
        }
    }

    private String runHTMLSuite(String browser, String browserURL, String suiteURL, File outputFile, long timeoutInSeconds, boolean multiWindow, String defaultLogLevel) throws IOException {
        outputFile.createNewFile();
        if (!outputFile.canWrite()) {
            throw new IOException("Can't write to outputFile: " + outputFile.getAbsolutePath());
        }
        long timeoutInMs = 1000L * timeoutInSeconds;
        if (timeoutInMs < 0L) {
            log.warn("Looks like the timeout overflowed, so resetting it to the maximum.");
            timeoutInMs = Long.MAX_VALUE;
        }
        RemoteControlConfiguration configuration = this.remoteControl.getConfiguration();
        this.remoteControl.handleHTMLRunnerResults(this);
        String sessionId = Long.toString(System.currentTimeMillis() % 1000000L);
        FrameGroupCommandQueueSet.makeQueueSet(sessionId, configuration.getPortDriversShouldContact(), configuration);
        Capabilities browserOptions = configuration.copySettingsIntoBrowserOptions((Capabilities)new DesiredCapabilities());
        browserOptions = BrowserOptions.setSingleWindow(browserOptions, !multiWindow);
        BrowserLauncher launcher = this.getBrowserLauncher(browser, sessionId, configuration, browserOptions);
        BrowserSessionFactory.BrowserSessionInfo sessionInfo = new BrowserSessionFactory.BrowserSessionInfo(sessionId, browser, browserURL, launcher, null);
        this.remoteControl.registerBrowserSession(sessionInfo);
        launcher.launchHTMLSuite(suiteURL, browserURL);
        this.sleepTight(timeoutInMs);
        launcher.close();
        this.remoteControl.deregisterBrowserSession(sessionInfo);
        if (this.results == null) {
            throw new SeleniumCommandTimedOutException();
        }
        this.writeResults(outputFile);
        return this.results.getResult().toUpperCase();
    }

    public String runHTMLSuite(String browser, String browserURL, File suiteFile, File outputFile, long timeoutInSeconds, boolean multiWindow) throws IOException {
        if (browser == null) {
            throw new IllegalArgumentException("browser may not be null");
        }
        if (!suiteFile.exists()) {
            throw new IOException("Can't find HTML Suite file:" + suiteFile.getAbsolutePath());
        }
        if (!suiteFile.canRead()) {
            throw new IOException("Can't read HTML Suite file: " + suiteFile.getAbsolutePath());
        }
        this.remoteControl.addNewStaticContent(suiteFile.getParentFile());
        String suiteURL = browser.startsWith("*chrome") || browser.startsWith("*firefox") || browser.startsWith("*iehta") || browser.startsWith("*iexplore") ? "http://localhost:" + this.remoteControl.getConfiguration().getPortDriversShouldContact() + "/selenium-server/tests/" + suiteFile.getName() : Urls.toProtocolHostAndPort((String)browserURL) + "/selenium-server/tests/" + suiteFile.getName();
        return this.runHTMLSuite(browser, browserURL, suiteURL, outputFile, timeoutInSeconds, multiWindow, "info");
    }

    public void processResults(HTMLTestResults resultsParm) {
        this.results = resultsParm;
    }

    public static int mainInt(String ... args) throws Exception {
        String[] browsers;
        if (args.length != 5 && args.length != 4) {
            throw new IllegalAccessException("Usage: HTMLLauncher outputDir testSuite startUrl multiWindow browser");
        }
        File dir = new File(args[0]);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Cannot create output directory for: " + dir);
        }
        String suite = args[1];
        String startURL = args[2];
        boolean multiWindow = Boolean.parseBoolean(args[3]);
        if (args.length == 4) {
            log.info("Running self tests");
            browsers = new String[]{"firefox", "iexploreproxy", "opera", "chrome"};
        } else {
            browsers = new String[]{args[4]};
        }
        SeleniumServer server = new SeleniumServer(false, new RemoteControlConfiguration());
        server.start();
        HTMLLauncher launcher = new HTMLLauncher(server);
        boolean passed = true;
        for (String browser : browsers) {
            File results = new File(dir, browser.substring(1) + ".results");
            String result = "FAILED";
            try {
                result = launcher.runHTMLSuite(browser, startURL, suite, results, 600L, multiWindow);
                passed &= "PASSED".equals(result);
            }
            catch (Throwable e) {
                log.warn("Test of browser failed: " + browser, e);
                passed = false;
            }
        }
        server.stop();
        return passed ? 1 : 0;
    }

    public static void main(String[] args) throws Exception {
        System.exit(HTMLLauncher.mainInt(args));
    }

    public HTMLTestResults getResults() {
        return this.results;
    }

    public void setResults(HTMLTestResults results) {
        this.results = results;
    }
}

